/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.platform.registry;

import com.blamejared.crafttweaker.platform.registry.RegistryWrapper;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ForgeRegistryWrapper<T extends IForgeRegistryEntry<T>>
implements RegistryWrapper<T> {
    private final IForgeRegistry<T> registry;

    public ForgeRegistryWrapper(IForgeRegistry<T> registry) {
        this.registry = registry;
    }

    @Override
    public Optional<T> getOptional(ResourceLocation location) {
        if (this.registry.containsKey(location)) {
            return Optional.ofNullable(this.registry.getValue(location));
        }
        return Optional.empty();
    }

    @Override
    public ResourceLocation getKey(T object) {
        return this.registry.getKey(object);
    }

    @Override
    public T get(ResourceLocation location) {
        return (T)this.registry.getValue(location);
    }

    @Override
    public Stream<T> stream() {
        return StreamSupport.stream(this.registry.spliterator(), false);
    }

    @Override
    public boolean containsKey(ResourceLocation location) {
        return this.registry.containsKey(location);
    }

    @Override
    public Set<ResourceLocation> keySet() {
        return this.registry.getKeys();
    }
}

