/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.natives.world;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.base.converter.tag.TagToDataConverter;
import com.blamejared.crafttweaker.api.util.sequence.SequenceBuilder;
import com.blamejared.crafttweaker.api.util.sequence.SequenceType;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.google.common.base.Suppliers;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/world/Level")
@NativeTypeRegistration(value=Level.class, zenCodeName="crafttweaker.api.world.Level")
public class ExpandLevel {
    @ZenCodeType.Method
    public static SequenceBuilder<Level, MapData> sequence(Level internal, @ZenCodeType.Optional(value="new crafttweaker.api.data.MapData()") MapData data) {
        return ExpandLevel.sequence(internal, MapData.class, data);
    }

    @ZenCodeType.Method
    public static <T> SequenceBuilder<Level, T> sequence(Level internal, Class<T> dataClass, T data) {
        return new SequenceBuilder(internal.f_46443_ ? SequenceType.CLIENT_THREAD_LEVEL : SequenceType.SERVER_THREAD_LEVEL, Suppliers.memoize(() -> internal), data);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isClientSide")
    public static boolean isClientSide(Level internal) {
        return internal.m_5776_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isDay")
    public static boolean isDay(Level internal) {
        return internal.m_46461_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isNight")
    public static boolean isNight(Level internal) {
        return internal.m_46462_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="gameTime")
    public static long getGametime(Level internal) {
        return internal.m_46467_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="daytime")
    public static long getDayTime(Level internal) {
        return internal.m_46468_();
    }

    @ZenCodeType.Getter(value="seaLevel")
    public static int getSeaLevel(Level internal) {
        return internal.m_5736_();
    }

    @ZenCodeType.Getter(value="raining")
    public static boolean isRaining(Level internal) {
        return internal.m_46471_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="rainLevel")
    public static void setRainingLevel(Level internal, float level) {
        internal.m_46734_(level);
    }

    @ZenCodeType.Getter(value="thundering")
    public static boolean isThundering(Level internal) {
        return internal.m_46470_();
    }

    @ZenCodeType.Getter(value="hardcore")
    public static boolean isHardcore(Level internal) {
        return internal.m_6106_().m_5466_();
    }

    @ZenCodeType.Getter(value="difficulty")
    public static String getDifficulty(Level internal) {
        return internal.m_6106_().m_5472_().m_19036_();
    }

    @ZenCodeType.Getter(value="difficultyLocked")
    public static boolean isDifficultyLocked(Level internal) {
        return internal.m_6106_().m_5474_();
    }

    @ZenCodeType.Getter(value="dimension")
    public static ResourceLocation getDimension(Level internal) {
        return internal.m_46472_().m_135782_();
    }

    @ZenCodeType.Method
    public static boolean isRainingAt(Level internal, BlockPos pos) {
        return internal.m_46758_(pos);
    }

    @ZenCodeType.Method
    public static int getDirectSignalTo(Level internal, BlockPos pos) {
        return internal.m_46751_(pos);
    }

    @ZenCodeType.Method
    public static int getSignal(Level internal, BlockPos pos, Direction direction) {
        return internal.m_46681_(pos, direction);
    }

    @ZenCodeType.Method
    public static int getBestNeighborSignal(Level internal, BlockPos pos) {
        return internal.m_46755_(pos);
    }

    @ZenCodeType.Method
    public static MapData getBlockEntityData(Level internal, BlockPos pos) {
        BlockEntity te = internal.m_7702_(pos);
        return te == null ? new MapData() : TagToDataConverter.convertCompound(te.m_187482_());
    }

    @ZenCodeType.Method
    public static boolean setBlockAndUpdate(Level internal, BlockPos pos, BlockState state) {
        return internal.m_46597_(pos, state);
    }

    @ZenCodeType.Method
    public static BlockState getBlockState(Level internal, BlockPos pos) {
        return internal.m_8055_(pos);
    }

    @ZenCodeType.Method
    public static boolean hasNeighborSignal(Level internal, BlockPos pos) {
        return internal.m_46753_(pos);
    }

    @ZenCodeType.Method
    public static Biome getBiome(Level internal, BlockPos pos) {
        return (Biome)internal.m_204166_(pos).m_203334_();
    }

    @ZenCodeType.Method
    public static boolean destroyBlock(Level internal, BlockPos pos, boolean doDrops) {
        return internal.m_46961_(pos, doDrops);
    }

    @ZenCodeType.Method
    public static boolean destroyBlock(Level internal, BlockPos pos, boolean doDrops, @ZenCodeType.Nullable Entity breaker) {
        return internal.m_46953_(pos, doDrops, breaker);
    }

    @ZenCodeType.Method
    public static void globalLevelEvent(Level internal, int eventId, BlockPos pos, int data) {
        internal.m_6798_(eventId, pos, data);
    }

    @ZenCodeType.Method
    public static void levelEvent(Level internal, @ZenCodeType.Nullable Player excluded, int eventId, BlockPos pos, int data) {
        internal.m_5898_(excluded, eventId, pos, data);
    }

    @ZenCodeType.Method
    public static boolean isEmptyBlock(Level internal, BlockPos pos) {
        return internal.m_46859_(pos);
    }

    @ZenCodeType.Method
    public static boolean isLoaded(Level internal, BlockPos pos) {
        return internal.m_46749_(pos);
    }

    @ZenCodeType.Method
    public static <T extends Entity> List<T> getEntitiesOfClass(Level internal, Class<T> typeOfT, double x1, double y1, double z1, double x2, double y2, double z2) {
        return internal.m_45976_(typeOfT, new AABB(x1, y1, z1, x2, y2, z2));
    }

    @ZenCodeType.Method
    public static <T extends Entity> List<T> getEntitiesInArea(Level internal, Class<T> typeOfT, BlockPos pos1, @ZenCodeType.Optional BlockPos pos2) {
        AABB aabb = new AABB(pos1);
        if (pos2 != null) {
            aabb = new AABB(pos1, pos2);
        }
        return internal.m_45976_(typeOfT, aabb);
    }

    @ZenCodeType.Method
    public static List<Entity> getEntities(Level internal, @ZenCodeType.Nullable Entity excludingEntity, double x1, double y1, double z1, double x2, double y2, double z2, Predicate<Entity> predicate) {
        return internal.m_6249_(excludingEntity, new AABB(x1, y1, z1, x2, y2, z2), predicate);
    }

    @ZenCodeType.Method
    public static List<Entity> getEntitiesInAreaExcluding(Level internal, @ZenCodeType.Nullable Entity excludingEntity, Predicate<Entity> predicate, BlockPos pos1, @ZenCodeType.Optional BlockPos pos2) {
        AABB aabb = new AABB(pos1);
        if (pos2 != null) {
            aabb = new AABB(pos1, pos2);
        }
        return internal.m_6249_(excludingEntity, aabb, predicate);
    }

    @ZenCodeType.Method
    public static @ZenCodeType.Nullable BlockEntity getBlockEntity(Level internal, BlockPos pos) {
        return internal.m_7702_(pos);
    }

    @ZenCodeType.Method
    public static boolean addFreshEntity(Level internal, Entity entity) {
        return internal.m_7967_(entity);
    }

    @ZenCodeType.Getter(value="random")
    public static Random getRandom(Level internal) {
        return internal.f_46441_;
    }

    @ZenCodeType.Method
    public static BlockHitResult rayTraceBlocks(Level internal, Vec3 startVec, Vec3 endVec, ClipContext.Block blockMode, ClipContext.Fluid fluidMode, @ZenCodeType.Optional Entity entity) {
        return internal.m_45547_(new ClipContext(startVec, endVec, blockMode, fluidMode, entity));
    }
}

