/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.script;

import com.blamejared.crafttweaker.CraftTweakerCommon;
import com.blamejared.crafttweaker.CraftTweakerRegistries;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.ingredient.IngredientCacheBuster;
import com.blamejared.crafttweaker.api.tag.CraftTweakerTagRegistry;
import com.blamejared.crafttweaker.api.util.sequence.SequenceManager;
import com.blamejared.crafttweaker.api.zencode.scriptrun.IScriptRun;
import com.blamejared.crafttweaker.api.zencode.scriptrun.ScriptRunConfiguration;
import com.blamejared.crafttweaker.impl.helper.FileGathererHelper;
import com.blamejared.crafttweaker.impl.script.ScriptRecipe;
import com.blamejared.crafttweaker.mixin.common.access.recipe.AccessRecipeManager;
import com.blamejared.crafttweaker.mixin.common.access.tag.AccessTagManager;
import com.blamejared.crafttweaker.platform.helper.IAccessibleServerElementsProvider;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.tags.TagManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.RecipeManager;

public class ScriptReloadListener
extends SimplePreparableReloadListener<Void> {
    private static final MutableComponent MSG_RELOAD_STARTING = new TranslatableComponent("crafttweaker.reload.start");
    private static final MutableComponent MSG_RELOAD_COMPLETE = new TranslatableComponent("crafttweaker.reload.complete");
    private static final Random RANDOM = ThreadLocalRandom.current();
    private final ReloadableServerResources resources;
    private final Consumer<MutableComponent> feedbackConsumer;

    public ScriptReloadListener(ReloadableServerResources managerSupplier, Consumer<MutableComponent> feedbackConsumer) {
        this.resources = managerSupplier;
        this.feedbackConsumer = feedbackConsumer;
    }

    protected Void prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        return null;
    }

    protected void apply(Void object, ResourceManager resourceManager, ProfilerFiller profiler) {
        IngredientCacheBuster.claim();
        SequenceManager.clearSequences();
        IAccessibleServerElementsProvider asep = CraftTweakerAPI.getAccessibleElementsProvider().server();
        asep.resources(this.resources);
        TagManager tagmanager = asep.accessibleResources().crafttweaker$getTagManager();
        asep.registryAccess(((AccessTagManager)tagmanager).crafttweaker$getRegistryAccess());
        CraftTweakerTagRegistry.INSTANCE.bind(tagmanager);
        RecipeManager manager = this.resources.m_206887_();
        this.feedbackConsumer.accept(MSG_RELOAD_STARTING);
        this.fixRecipeManager(manager);
        Pair<Path, List<Path>> scripts = this.gatherScripts();
        IScriptRun preparedRun = this.prepareRun(scripts);
        try {
            preparedRun.execute();
        }
        catch (Throwable e) {
            CraftTweakerAPI.LOGGER.error("Unable to execute script run", e);
            return;
        }
        this.storeScriptsInRecipes(manager, scripts);
        this.feedbackConsumer.accept(MSG_RELOAD_COMPLETE);
        if (!((List)scripts.getSecond()).isEmpty() && preparedRun.specificRunInfo().displayBranding()) {
            this.displayPatreonBranding();
        }
        IngredientCacheBuster.release();
    }

    private void fixRecipeManager(RecipeManager manager) {
        AccessRecipeManager accessRecipeManager = (AccessRecipeManager)manager;
        accessRecipeManager.crafttweaker$setRecipes(new HashMap(accessRecipeManager.crafttweaker$getRecipes()));
        accessRecipeManager.crafttweaker$getRecipes().replaceAll((k, v) -> new HashMap(accessRecipeManager.crafttweaker$getRecipes().get(k)));
        accessRecipeManager.crafttweaker$setByName(new HashMap(accessRecipeManager.crafttweaker$getByName()));
        CraftTweakerAPI.getAccessibleElementsProvider().recipeManager(manager);
    }

    private Pair<Path, List<Path>> gatherScripts() {
        Path root = CraftTweakerAPI.getScriptsDirectory();
        PathMatcher matcher = root.getFileSystem().getPathMatcher("glob:**.zs");
        ArrayList children = new ArrayList();
        try {
            Files.walkFileTree(root, FileGathererHelper.of(matcher, children::add));
        }
        catch (IOException e) {
            CraftTweakerAPI.LOGGER.error("Unable to read script files! This is serious", (Throwable)e);
        }
        return Pair.of((Object)root, Collections.unmodifiableList(children));
    }

    private IScriptRun prepareRun(Pair<Path, List<Path>> scripts) {
        ScriptRunConfiguration configuration = new ScriptRunConfiguration("crafttweaker", CraftTweakerConstants.RELOAD_LISTENER_SOURCE_ID, ScriptRunConfiguration.RunKind.EXECUTE);
        return CraftTweakerAPI.getScriptRunManager().createScriptRun((Path)scripts.getFirst(), (List)scripts.getSecond(), configuration);
    }

    private void storeScriptsInRecipes(RecipeManager manager, Pair<Path, List<Path>> scripts) {
        Map recipes = ((AccessRecipeManager)manager).crafttweaker$getRecipes().computeIfAbsent(CraftTweakerRegistries.RECIPE_TYPE_SCRIPTS, it -> new HashMap());
        Path root = (Path)scripts.getFirst();
        ((List)scripts.getSecond()).stream().map(it -> this.buildScriptRecipe((Path)it, root)).forEach(it -> recipes.put(it.m_6423_(), it));
    }

    private ScriptRecipe buildScriptRecipe(Path file, Path root) {
        String fileName = root.relativize(file).toString().replace('\\', '/');
        String sanitizedFileName = fileName.toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9_.-]", "_");
        ResourceLocation id = CraftTweakerConstants.rl(sanitizedFileName);
        return new ScriptRecipe(id, fileName, this.readContents(file));
    }

    private String readContents(Path file) {
        try {
            return String.join((CharSequence)"\n", Files.readAllLines(file));
        }
        catch (IOException e) {
            CraftTweakerAPI.LOGGER.info("Unable to read script file " + file, (Throwable)e);
            return "";
        }
    }

    private void displayPatreonBranding() {
        Set<String> patronList = CraftTweakerCommon.getPatronList();
        patronList.stream().skip(patronList.isEmpty() ? 0L : (long)RANDOM.nextInt(patronList.size())).findFirst().ifPresent(name -> CraftTweakerAPI.LOGGER.info("This reload was made possible by {} and more! Become a patron at https://patreon.com/jaredlll08?s=crtmod", name));
    }
}

