/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipe.handler.type.vanilla;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IReplacementRule;
import com.blamejared.crafttweaker.api.recipe.handler.helper.ReplacementHandlerHelper;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.blamejared.crafttweaker.platform.Services;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;

@IRecipeHandler.For(value=ShapelessRecipe.class)
public final class ShapelessRecipeHandler
implements IRecipeHandler<ShapelessRecipe> {
    @Override
    public String dumpToCommandString(IRecipeManager manager, ShapelessRecipe recipe) {
        return String.format("craftingTable.addShapeless(%s, %s, %s);", StringUtil.quoteAndEscape(recipe.m_6423_()), ItemStackUtil.getCommandString(recipe.m_8043_()), recipe.m_7527_().stream().map(IIngredient::fromIngredient).map(IIngredient::getCommandString).collect(Collectors.joining(", ", "[", "]")));
    }

    @Override
    public Optional<Function<ResourceLocation, ShapelessRecipe>> replaceIngredients(IRecipeManager manager, ShapelessRecipe recipe, List<IReplacementRule> rules) {
        return ReplacementHandlerHelper.replaceNonNullIngredientList(recipe.m_7527_(), Ingredient.class, recipe, rules, newIngredients -> id -> new ShapelessRecipe(id, recipe.m_6076_(), recipe.m_8043_(), newIngredients));
    }

    @Override
    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager manager, ShapelessRecipe firstRecipe, U secondRecipe) {
        return Services.PLATFORM.doCraftingTableRecipesConflict(manager, (Recipe<?>)firstRecipe, secondRecipe);
    }
}

