/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipe.handler.type.vanilla;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IReplacementRule;
import com.blamejared.crafttweaker.api.recipe.handler.helper.ReplacementHandlerHelper;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.blamejared.crafttweaker.platform.Services;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;

@IRecipeHandler.For(value=ShapedRecipe.class)
public final class ShapedRecipeHandler
implements IRecipeHandler<ShapedRecipe> {
    @Override
    public String dumpToCommandString(IRecipeManager manager, ShapedRecipe recipe) {
        NonNullList ingredients = recipe.m_7527_();
        return String.format("craftingTable.addShaped(%s, %s, %s);", StringUtil.quoteAndEscape(recipe.m_6423_()), ItemStackUtil.getCommandString(recipe.m_8043_()), IntStream.range(0, recipe.m_44221_()).mapToObj(y -> IntStream.range(0, recipe.m_44220_()).mapToObj(x -> (Ingredient)ingredients.get(y * recipe.m_44220_() + x)).map(IIngredient::fromIngredient).map(IIngredient::getCommandString).collect(Collectors.joining(", ", "[", "]"))).collect(Collectors.joining(", ", "[", "]")));
    }

    @Override
    public Optional<Function<ResourceLocation, ShapedRecipe>> replaceIngredients(IRecipeManager manager, ShapedRecipe recipe, List<IReplacementRule> rules) {
        return ReplacementHandlerHelper.replaceNonNullIngredientList(recipe.m_7527_(), Ingredient.class, recipe, rules, newIngredients -> id -> new ShapedRecipe(id, recipe.m_6076_(), recipe.m_44220_(), recipe.m_44221_(), newIngredients, recipe.m_8043_()));
    }

    @Override
    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager manager, ShapedRecipe firstRecipe, U secondRecipe) {
        return Services.PLATFORM.doCraftingTableRecipesConflict(manager, (Recipe<?>)firstRecipe, secondRecipe);
    }
}

