/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.command.type.script.example;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.api.plugin.ICommandRegistrationHandler;
import com.blamejared.crafttweaker.impl.command.type.script.example.ResourceManagerSourceFile;
import com.blamejared.crafttweaker.mixin.common.access.server.AccessMinecraftServer;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.io.input.ReaderInputStream;
import org.openzen.zencode.shared.SourceFile;

public final class ExamplesCommand {
    private ExamplesCommand() {
    }

    public static void registerCommand(ICommandRegistrationHandler handler) {
        handler.registerRootCommand("examples", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.examples"), builder -> ((LiteralArgumentBuilder)builder.requires(source -> source.m_6761_(2))).executes(ctx -> ExamplesCommand.execute(((CommandSourceStack)ctx.getSource()).m_81375_())));
    }

    private static int execute(ServerPlayer player) {
        MinecraftServer server = player.f_8924_;
        MinecraftServer.ReloadableResources reloadableResources = ((AccessMinecraftServer)server).crafttweaker$getResources();
        CloseableResourceManager resourceManager = reloadableResources.f_206584_();
        for (ResourceLocation file : resourceManager.m_6540_("scripts", n -> n.endsWith(".zs"))) {
            ExamplesCommand.writeScriptFile(new ResourceManagerSourceFile(file, (ResourceManager)resourceManager));
        }
        player.m_6352_(CommandUtilities.openingFile(new TranslatableComponent("crafttweaker.command.example.generated").m_130940_(ChatFormatting.GREEN), ExamplesCommand.getExamplesDir().toString()), CraftTweakerConstants.CRAFTTWEAKER_UUID);
        return 1;
    }

    private static void writeScriptFile(SourceFile sourceFile) {
        Path file = ExamplesCommand.getExamplesDir().resolve(sourceFile.getFilename());
        if (Files.exists(file, new LinkOption[0])) {
            CraftTweakerAPI.LOGGER.info("Skip writing example file '{}' since it already exists", (Object)file);
            return;
        }
        if (!Files.exists(file.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                CraftTweakerAPI.LOGGER.error("Could not create folder '" + file.getParent() + "'", (Throwable)e);
                return;
            }
        }
        try (Reader reader = sourceFile.open();
             ReaderInputStream stream = new ReaderInputStream(reader, StandardCharsets.UTF_8);){
            Files.copy((InputStream)stream, file, new CopyOption[0]);
        }
        catch (IOException e) {
            CraftTweakerAPI.LOGGER.warn("Could not write script example: ", (Throwable)e);
        }
    }

    private static Path getExamplesDir() {
        return CraftTweakerAPI.getScriptsDirectory().resolve("./examples");
    }
}

