/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.handler.helper;

import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandlerRegistry;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.IngredientUtil;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.common.crafting.IShapedRecipe;

public final class CraftingTableRecipeConflictChecker {
    public static boolean checkConflicts(IRecipeManager manager, Recipe<?> first, Recipe<?> second) {
        if (first.m_5598_() || second.m_5598_()) {
            return false;
        }
        if (!(first instanceof IShapedRecipe) && second instanceof IShapedRecipe) {
            return CraftingTableRecipeConflictChecker.redirect(manager, second, first);
        }
        return CraftingTableRecipeConflictChecker.checkConflictsMaybeDifferent(first, second);
    }

    private static <T extends Recipe<?>> boolean redirect(IRecipeManager manager, T second, Recipe<?> first) {
        return IRecipeHandlerRegistry.getHandlerFor(second).doesConflict(manager, second, first);
    }

    private static boolean checkConflictsMaybeDifferent(Recipe<?> first, Recipe<?> second) {
        if (first instanceof IShapedRecipe) {
            if (second instanceof IShapedRecipe) {
                return CraftingTableRecipeConflictChecker.doShapedShapedConflict((IShapedRecipe)first, (IShapedRecipe)second);
            }
            return CraftingTableRecipeConflictChecker.doShapedShapelessConflict((IShapedRecipe)first, second);
        }
        return CraftingTableRecipeConflictChecker.doShapelessShapelessConflict(first, second);
    }

    private static boolean doShapedShapedConflict(IShapedRecipe<?> first, IShapedRecipe<?> second) {
        if (first.getRecipeHeight() != second.getRecipeHeight()) {
            return false;
        }
        if (first.getRecipeWidth() != second.getRecipeWidth()) {
            return false;
        }
        NonNullList firstIngredients = first.m_7527_();
        NonNullList secondIngredients = second.m_7527_();
        for (int i = 0; i < firstIngredients.size(); ++i) {
            Ingredient secondIngredient;
            Ingredient firstIngredient = (Ingredient)firstIngredients.get(i);
            if (IngredientUtil.canConflict(firstIngredient, secondIngredient = (Ingredient)secondIngredients.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean doShapedShapelessConflict(IShapedRecipe<?> first, Recipe<?> second) {
        return CraftingTableRecipeConflictChecker.doShapelessShapelessConflict(first.m_7527_().stream().filter(it -> it != Ingredient.f_43901_).collect(Collectors.toList()), (List<Ingredient>)second.m_7527_());
    }

    private static boolean doShapelessShapelessConflict(Recipe<?> first, Recipe<?> second) {
        return CraftingTableRecipeConflictChecker.doShapelessShapelessConflict((List<Ingredient>)first.m_7527_(), (List<Ingredient>)second.m_7527_());
    }

    private static boolean doShapelessShapelessConflict(List<Ingredient> first, List<Ingredient> second) {
        if (first.size() != second.size()) {
            return false;
        }
        return IngredientUtil.doIngredientsConflict(first, second);
    }
}

