/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.fluid;

import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.base.converter.tag.TagToDataConverter;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.fluid.MCFluidStack;
import java.util.Objects;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;

public class MCFluidStackMutable
implements IFluidStack {
    private final FluidStack stack;

    public MCFluidStackMutable(FluidStack stack) {
        this.stack = stack;
    }

    @Override
    public IFluidStack setAmount(int amount) {
        return this.multiply(amount);
    }

    @Override
    public IFluidStack multiply(int amount) {
        this.getInternal().setAmount(amount);
        return this;
    }

    @Override
    public IFluidStack mutable() {
        return this;
    }

    @Override
    public IFluidStack asImmutable() {
        return new MCFluidStack(this.getInternal().copy());
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public Fluid getFluid() {
        return this.getInternal().getFluid();
    }

    @Override
    public IFluidStack withTag(MapData tag) {
        if (tag != null) {
            tag = new MapData(tag.asMap());
            this.getInternal().setTag(tag.getInternal());
        } else {
            this.getInternal().setTag(null);
        }
        return this;
    }

    @Override
    public MapData getTag() {
        return TagToDataConverter.convertCompound(this.getInternal().getTag());
    }

    @Override
    public IFluidStack copy() {
        return new MCFluidStackMutable(this.getInternal().copy());
    }

    @Override
    public FluidStack getInternal() {
        return this.stack;
    }

    @Override
    public FluidStack getImmutableInternal() {
        return this.stack.copy();
    }

    @Override
    public String getCommandString() {
        MapData data;
        Fluid fluid = this.getInternal().getFluid();
        StringBuilder stringBuilder = new StringBuilder("<fluid:");
        stringBuilder.append(fluid.getRegistryName());
        stringBuilder.append(">");
        if (this.getInternal().hasTag() && !(data = TagToDataConverter.convertCompound(this.getInternal().getTag()).copyInternal()).isEmpty()) {
            stringBuilder.append(".withTag(");
            stringBuilder.append(data.asString());
            stringBuilder.append(")");
        }
        if (!this.isEmpty() && this.getInternal().getAmount() != 1) {
            stringBuilder.append(" * ").append(this.getInternal().getAmount());
        }
        return stringBuilder.toString();
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FluidStack thatStack = ((MCFluidStackMutable)o).getInternal();
        FluidStack thisStack = this.getInternal();
        if (thisStack.isEmpty()) {
            return thatStack.isEmpty();
        }
        if (thisStack.getAmount() != thatStack.getAmount()) {
            return false;
        }
        if (!Objects.equals(thisStack.getFluid(), thatStack.getFluid())) {
            return false;
        }
        return Objects.equals(thisStack.getTag(), thatStack.getTag());
    }

    public int hashCode() {
        return Objects.hash(this.getInternal().getAmount(), this.getInternal().getFluid(), this.getInternal().getTag());
    }
}

