/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.recipe;

import com.blamejared.crafttweaker.api.action.recipe.ActionRecipeBase;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.platform.Services;
import net.minecraft.world.item.crafting.Recipe;

public class ActionAddRecipe<T extends Recipe<?>>
extends ActionRecipeBase<T> {
    protected final T recipe;
    private final String subType;

    public ActionAddRecipe(IRecipeManager<T> recipeManager, T recipe, String subType) {
        super(recipeManager);
        this.recipe = recipe;
        this.subType = subType;
    }

    public ActionAddRecipe(IRecipeManager<T> recipeManager, T recipe) {
        super(recipeManager);
        this.recipe = recipe;
        this.subType = "";
    }

    @Override
    public void apply() {
        this.getRecipeMutator().add(this.recipe.m_6423_(), this.recipe);
    }

    @Override
    public String describe() {
        return "Adding '%s' recipe%s, with name: '%s' that outputs: '%s'".formatted(this.getManager().getBracketResourceLocation(), this.getSubTypeDescription(), this.recipe.m_6423_(), this.describeOutputs());
    }

    protected String describeOutputs() {
        return Services.PLATFORM.createMCItemStackMutable(this.recipe.m_8043_()).getCommandString();
    }

    private String getSubTypeDescription() {
        if (this.subType != null && !this.subType.isBlank()) {
            return ", of type: \"" + this.subType + "\"";
        }
        return "";
    }
}

