/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns;

import com.mrcrayfish.framework.api.client.FrameworkClientAPI;
import com.mrcrayfish.framework.api.client.resources.IDataLoader;
import com.mrcrayfish.guns.Config;
import com.mrcrayfish.guns.client.ClientHandler;
import com.mrcrayfish.guns.client.CustomGunManager;
import com.mrcrayfish.guns.client.MetaLoader;
import com.mrcrayfish.guns.client.handler.CrosshairHandler;
import com.mrcrayfish.guns.common.BoundingBoxManager;
import com.mrcrayfish.guns.common.ProjectileManager;
import com.mrcrayfish.guns.crafting.ModRecipeType;
import com.mrcrayfish.guns.crafting.WorkbenchIngredient;
import com.mrcrayfish.guns.datagen.BlockTagGen;
import com.mrcrayfish.guns.datagen.GunGen;
import com.mrcrayfish.guns.datagen.ItemTagGen;
import com.mrcrayfish.guns.datagen.LanguageGen;
import com.mrcrayfish.guns.datagen.LootTableGen;
import com.mrcrayfish.guns.datagen.RecipeGen;
import com.mrcrayfish.guns.enchantment.EnchantmentTypes;
import com.mrcrayfish.guns.entity.GrenadeEntity;
import com.mrcrayfish.guns.entity.MissileEntity;
import com.mrcrayfish.guns.entity.ProjectileEntity;
import com.mrcrayfish.guns.init.ModBlocks;
import com.mrcrayfish.guns.init.ModContainers;
import com.mrcrayfish.guns.init.ModEffects;
import com.mrcrayfish.guns.init.ModEnchantments;
import com.mrcrayfish.guns.init.ModEntities;
import com.mrcrayfish.guns.init.ModItems;
import com.mrcrayfish.guns.init.ModParticleTypes;
import com.mrcrayfish.guns.init.ModRecipeSerializers;
import com.mrcrayfish.guns.init.ModSounds;
import com.mrcrayfish.guns.init.ModSyncedDataKeys;
import com.mrcrayfish.guns.init.ModTileEntities;
import com.mrcrayfish.guns.item.GunItem;
import com.mrcrayfish.guns.network.PacketHandler;
import net.minecraft.core.NonNullList;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cgm")
public class GunMod {
    public static boolean debugging = false;
    public static boolean controllableLoaded = false;
    public static boolean backpackedLoaded = false;
    public static boolean playerReviveLoaded = false;
    public static final Logger LOGGER = LogManager.getLogger((String)"cgm");
    public static final CreativeModeTab GROUP = new CreativeModeTab("cgm"){

        public ItemStack m_6976_() {
            ItemStack stack = new ItemStack((ItemLike)ModItems.PISTOL.get());
            stack.m_41784_().m_128405_("AmmoCount", ((GunItem)ModItems.PISTOL.get()).getGun().getGeneral().getMaxAmmo());
            return stack;
        }

        public void m_6151_(NonNullList<ItemStack> items) {
            super.m_6151_(items);
            CustomGunManager.fill(items);
        }
    }.m_40781_(new EnchantmentCategory[]{EnchantmentTypes.GUN, EnchantmentTypes.SEMI_AUTO_GUN});

    public GunMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.serverSpec);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModBlocks.REGISTER.register(bus);
        ModContainers.REGISTER.register(bus);
        ModEffects.REGISTER.register(bus);
        ModEnchantments.REGISTER.register(bus);
        ModEntities.REGISTER.register(bus);
        ModItems.REGISTER.register(bus);
        ModParticleTypes.REGISTER.register(bus);
        ModRecipeSerializers.REGISTER.register(bus);
        ModSounds.REGISTER.register(bus);
        ModTileEntities.REGISTER.register(bus);
        bus.addListener(this::onCommonSetup);
        bus.addListener(this::onClientSetup);
        bus.addListener(this::onGatherData);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            bus.addListener(CrosshairHandler::onConfigReload);
            bus.addListener(ClientHandler::onRegisterReloadListener);
            FrameworkClientAPI.registerDataLoader((IDataLoader)MetaLoader.getInstance());
        });
        controllableLoaded = ModList.get().isLoaded("controllable");
        backpackedLoaded = ModList.get().isLoaded("backpacked");
        playerReviveLoaded = ModList.get().isLoaded("playerrevive");
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ModRecipeType.init();
            ModSyncedDataKeys.register();
            CraftingHelper.register((ResourceLocation)new ResourceLocation("cgm", "workbench_ingredient"), (IIngredientSerializer)WorkbenchIngredient.Serializer.INSTANCE);
            ProjectileManager.getInstance().registerFactory((Item)ModItems.GRENADE.get(), (worldIn, entity, weapon, item, modifiedGun) -> new GrenadeEntity((EntityType<? extends ProjectileEntity>)((EntityType)ModEntities.GRENADE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.MISSILE.get(), (worldIn, entity, weapon, item, modifiedGun) -> new MissileEntity((EntityType<? extends ProjectileEntity>)((EntityType)ModEntities.MISSILE.get()), worldIn, entity, weapon, item, modifiedGun));
            PacketHandler.init();
            if (((Boolean)Config.COMMON.gameplay.improvedHitboxes.get()).booleanValue()) {
                MinecraftForge.EVENT_BUS.register((Object)new BoundingBoxManager());
            }
        });
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(ClientHandler::setup);
    }

    private void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        BlockTagGen blockTagGen = new BlockTagGen(generator, existingFileHelper);
        generator.m_123914_((DataProvider)new RecipeGen(generator));
        generator.m_123914_((DataProvider)new LootTableGen(generator));
        generator.m_123914_((DataProvider)blockTagGen);
        generator.m_123914_((DataProvider)new ItemTagGen(generator, blockTagGen, existingFileHelper));
        generator.m_123914_((DataProvider)new LanguageGen(generator));
        generator.m_123914_((DataProvider)new GunGen(generator));
    }

    public static boolean isDebugging() {
        return false;
    }
}

