/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.mixin.impl;

import me.srrapero720.waterframes.WFConfig;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import net.minecraft.Util;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={MinecraftServer.class})
public class MinecraftServerMixin {
    @Unique
    private static long wf$lastWarnTime = 0L;
    @Unique
    private static long wf$lastMillisTime = 0L;
    @Unique
    private static long wf$timeStack = 0L;

    @Redirect(method={"runServer"}, at=@At(value="INVOKE", target="Lnet/minecraft/Util;getMillis()J", ordinal=0))
    public long redirect$runServer$getMillis() {
        wf$lastMillisTime = Util.m_137550_();
        return wf$lastMillisTime;
    }

    @Redirect(method={"runServer"}, at=@At(value="INVOKE", target="Lnet/minecraft/Util;getMillis()J", ordinal=1))
    public long redirect$runServer$getMillisWhile() {
        if (!WFConfig.useLagTickCorrection()) {
            return Util.m_137550_();
        }
        long millis = Util.m_137550_();
        long time = millis - wf$lastMillisTime;
        if (time > 100L) {
            wf$timeStack += time;
        }
        if (wf$timeStack > 1000L) {
            DisplayTile.setLagTickTime(wf$timeStack);
            if (millis - wf$lastWarnTime > 15000L) {
                WaterFrames.LOGGER.warn("Server seems overloading, jumping {}ms or {} ticks", (Object)wf$timeStack, (Object)(wf$timeStack / 50L));
                wf$lastWarnTime = millis;
            }
            wf$timeStack %= 1000L;
        }
        wf$lastMillisTime = Util.m_137550_();
        return wf$lastMillisTime;
    }
}

