/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.screens.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import me.srrapero720.waterframes.common.block.data.types.PositionHorizontal;
import me.srrapero720.waterframes.common.block.data.types.PositionVertical;
import me.srrapero720.waterframes.common.screens.styles.IconStyles;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import team.creative.creativecore.client.render.GuiRenderHelper;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.controls.simple.GuiIcon;
import team.creative.creativecore.common.gui.style.Icon;
import team.creative.creativecore.common.util.math.geo.Rect;

public class WidgetClickableArea
extends GuiIcon {
    private PositionHorizontal x;
    private PositionVertical y;
    private boolean selected = false;

    public WidgetClickableArea(String name, PositionHorizontal x, PositionVertical y) {
        super(name, IconStyles.POS_BASE);
        this.x = x;
        this.y = y;
    }

    protected void renderContent(PoseStack pose, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
        super.renderContent(pose, control, rect, mouseX, mouseY);
        this.renderSelector(pose, control, rect, mouseX, mouseY);
    }

    protected void renderSelector(PoseStack pose, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
        Icon icon = IconStyles.POS_ICON;
        int width = Math.round((float)control.getContentWidth() / 3.0f);
        int height = Math.round((float)control.getContentHeight() / 3.0f);
        int offsetX = switch (this.x) {
            default -> throw new IncompatibleClassChangeError();
            case PositionHorizontal.LEFT -> 0;
            case PositionHorizontal.CENTER -> width;
            case PositionHorizontal.RIGHT -> Math.round((float)width * 2.0f) - 1;
        };
        int offsetY = switch (this.y) {
            default -> throw new IncompatibleClassChangeError();
            case PositionVertical.TOP -> 0;
            case PositionVertical.CENTER -> height;
            case PositionVertical.BOTTOM -> Math.round((float)height * 2.0f) - 1;
        };
        pose.m_85836_();
        RenderSystem.m_69482_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)icon.location());
        this.color.glColor();
        GuiRenderHelper.textureRect((PoseStack)pose, (int)offsetX, (int)offsetY, (int)width, (int)height, (float)icon.minX(), (float)icon.minY(), (float)(icon.minX() + icon.width()), (float)(icon.minY() + icon.height()));
        RenderSystem.m_69461_();
        pose.m_85849_();
    }

    public boolean mouseClicked(Rect rect, double mouseX, double mouseY, int button) {
        WidgetClickableArea.playSound((SoundEvent)SoundEvents.f_12490_);
        this.selected = true;
        this.mouseMoved(rect, mouseX, mouseY);
        return true;
    }

    public void mouseMoved(Rect rect, double mouseX, double mouseY) {
        super.mouseMoved(rect, mouseX, mouseY);
        if (this.selected) {
            int areaX = (int)(mouseX / rect.getWidth() * 3.0);
            int areaY = (int)(mouseY / rect.getHeight() * 3.0);
            this.x = switch (areaX) {
                case 0 -> PositionHorizontal.LEFT;
                case 1 -> PositionHorizontal.CENTER;
                case 2, 3 -> PositionHorizontal.RIGHT;
                default -> areaX > 3 ? PositionHorizontal.RIGHT : PositionHorizontal.LEFT;
            };
            this.y = switch (areaY) {
                case 0 -> PositionVertical.TOP;
                case 1 -> PositionVertical.CENTER;
                case 2, 3 -> PositionVertical.BOTTOM;
                default -> areaY > 3 ? PositionVertical.BOTTOM : PositionVertical.TOP;
            };
        }
    }

    public void mouseReleased(Rect rect, double x, double y, int button) {
        this.selected = false;
        super.mouseReleased(rect, x, y, button);
    }

    public List<Component> getTooltip() {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        tooltips.add((Component)WidgetClickableArea.translatable((String)"waterframes.gui.position.desc"));
        tooltips.add((Component)WidgetClickableArea.translatable((String)"waterframes.gui.position.vertical", (Object[])new Object[]{ChatFormatting.AQUA + WidgetClickableArea.translate((String)("waterframes.gui.position." + this.y.name().toLowerCase()))}));
        tooltips.add((Component)WidgetClickableArea.translatable((String)"waterframes.gui.position.horizontal", (Object[])new Object[]{ChatFormatting.AQUA + WidgetClickableArea.translate((String)("waterframes.gui.position." + this.x.name().toLowerCase()))}));
        return tooltips;
    }

    public PositionHorizontal getX() {
        return this.x;
    }

    public PositionVertical getY() {
        return this.y;
    }
}

