/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.block;

import me.srrapero720.waterframes.WFConfig;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.network.DisplayNetwork;
import me.srrapero720.waterframes.common.network.packets.PermLevelPacket;
import me.srrapero720.waterframes.common.screens.DisplayScreen;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.creator.BlockGuiCreator;
import team.creative.creativecore.common.gui.creator.GuiCreator;

@MethodsReturnNonnullByDefault
@FieldsAreNonnullByDefault
public abstract class DisplayBlock
extends BaseEntityBlock
implements BlockGuiCreator,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty VISIBLE = new BooleanProperty("frame"){};
    public static final DirectionProperty ATTACHED_FACE = DirectionProperty.m_61549_((String)"attached_face", (Direction[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP, Direction.DOWN});
    private static final Material MATERIAL = new Material.Builder(MaterialColor.f_76398_).m_76354_().m_76359_();
    private static final BlockBehaviour.Properties PROPERTIES = BlockBehaviour.Properties.m_60939_((Material)MATERIAL).m_60978_(1.0f).m_60918_(SoundType.f_56743_).m_60955_().m_60960_(Blocks::m_50805_).m_60971_(Blocks::m_50805_).m_60999_();

    protected DisplayBlock() {
        super(PROPERTIES);
    }

    public abstract DirectionProperty getFacing();

    public GuiLayer create(CompoundTag tag, Level level, BlockPos blockPos, BlockState blockState, Player player) {
        DisplayScreen displayScreen;
        BlockEntity blockEntity;
        if (!level.f_46443_) {
            DisplayNetwork.sendClient(new PermLevelPacket(level.m_142572_()), level, blockPos);
        }
        if ((blockEntity = level.m_7702_(blockPos)) instanceof DisplayTile) {
            DisplayTile tile = (DisplayTile)blockEntity;
            displayScreen = new DisplayScreen(tile);
        } else {
            displayScreen = null;
        }
        return displayScreen;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_ && WFConfig.canInteractBlock(player)) {
            GuiCreator.BLOCK_OPENER.open(player, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return state.m_61143_((Property)this.getFacing()) == direction;
    }

    protected void m_49959_(BlockState state) {
        super.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{this.getFacing()}).m_61104_(new Property[]{ATTACHED_FACE}).m_61104_(new Property[]{POWERED}).m_61104_(new Property[]{POWER}).m_61104_(new Property[]{WATERLOGGED}).m_61104_(new Property[]{LIT}));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction current = context.m_8125_();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0))).m_61124_((Property)ATTACHED_FACE, (Comparable)context.m_43719_())).m_61124_((Property)this.getFacing(), (Comparable)(context.m_43723_().m_6047_() ? current.m_122424_() : current))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    public RenderShape m_7514_(BlockState state) {
        return state.m_61138_((Property)VISIBLE) ? (((Boolean)state.m_61143_((Property)VISIBLE)).booleanValue() ? RenderShape.MODEL : RenderShape.INVISIBLE) : RenderShape.MODEL;
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.m_5940_(state, level, pos, null);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> type) {
        return (l, pos, state, be) -> {
            if (be instanceof DisplayTile) {
                DisplayTile tile = (DisplayTile)be;
                tile.tick(tile.m_58899_(), state);
            }
        };
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighborPos, boolean isMoving) {
        BlockEntity blockEntity;
        super.m_6861_(state, level, pos, block, neighborPos, isMoving);
        if (!WFConfig.useRedstone() || !((blockEntity = level.m_7702_(pos)) instanceof DisplayTile)) {
            return;
        }
        DisplayTile tile = (DisplayTile)blockEntity;
        boolean signal = level.m_46753_(pos);
        if ((Boolean)state.m_61143_((Property)POWERED) != signal) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(signal)), 3);
            if (!level.f_46443_) {
                tile.setPause(false, signal);
            }
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)POWER);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            return level.m_7469_();
        }
        return 0;
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return 0.0f;
    }

    public PushReaction m_5537_(BlockState pState) {
        return PushReaction.DESTROY;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(true) : super.m_5888_(state);
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation) {
        return this.m_6843_(state, rotation);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)this.getFacing(), (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)this.getFacing())));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)this.getFacing(), (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)this.getFacing())));
    }
}

