/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.client.rendering.core;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.Vec3i;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.box.BoxFace;

public class RenderCore {
    private static final Tesselator tesselator = Tesselator.m_85913_();
    private static final BufferBuilder builder = tesselator.m_85915_();

    public static void cleanShader() {
        ShaderInstance shader = RenderSystem.m_157196_();
        shader.m_173363_();
        shader.m_173362_();
    }

    public static void bufferPrepare() {
        if (builder.m_85732_()) {
            RenderCore.bufferEnd();
        }
        RenderSystem.m_157427_(GameRenderer::m_172820_);
    }

    public static void bufferBegin() {
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85822_);
    }

    public static void bufferFinish() {
        builder.m_85721_();
    }

    public static void bufferEnd() {
        tesselator.m_85914_();
    }

    public static void bindTex(int texture) {
        RenderSystem.m_69396_((int)texture);
        RenderSystem.m_157453_((int)0, (int)texture);
        RenderSystem.m_69937_((int)3553, (int)10241, (int)9728);
        RenderSystem.m_69937_((int)3553, (int)10240, (int)9728);
    }

    public static void unbindTex() {
        RenderSystem.m_69396_((int)0);
        RenderSystem.m_157453_((int)0, (int)0);
    }

    public static void vertexF(PoseStack pose, AlignedBox box, BoxFace face, boolean flipX, boolean flipY, int a, int r, int g, int b) {
        for (int i = 0; i < face.corners.length; ++i) {
            RenderCore.vertex(pose, box, face, face.corners[i], flipX, flipY, a, r, g, b);
        }
    }

    public static void vertexB(PoseStack pose, AlignedBox box, BoxFace face, boolean flipX, boolean flipY, int a, int r, int g, int b) {
        for (int i = face.corners.length - 1; i >= 0; --i) {
            RenderCore.vertex(pose, box, face, face.corners[i], flipX, flipY, a, r, g, b);
        }
    }

    private static void vertex(PoseStack pose, AlignedBox box, BoxFace face, BoxCorner corner, boolean flipX, boolean flipY, int a, int r, int g, int b) {
        Vec3i normal = face.facing.normal;
        builder.m_85982_(pose.m_85850_().m_85861_(), box.get(corner.x), box.get(corner.y), box.get(corner.z)).m_7421_(corner.isFacing(face.getTexU()) != flipX ? 1.0f : 0.0f, corner.isFacing(face.getTexV()) != flipY ? 1.0f : 0.0f).m_6122_(r, g, b, a).m_85977_(pose.m_85850_().m_85864_(), (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
    }
}

