/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.client.rendering;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import me.srrapero720.waterframes.WFConfig;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.client.display.DisplayControl;
import me.srrapero720.waterframes.client.display.TextureDisplay;
import me.srrapero720.waterframes.client.rendering.core.RenderCore;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.watermedia.api.image.ImageAPI;
import me.srrapero720.watermedia.api.image.ImageRenderer;
import me.srrapero720.watermedia.api.math.MathAPI;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.creativecore.common.util.math.box.BoxFace;

public class DisplayRenderer
implements BlockEntityRenderer<DisplayTile> {
    public static final ImageRenderer LOADING_TEX = ImageAPI.loadingGif((String)"waterframes");

    public DisplayRenderer(BlockEntityRendererProvider.Context context) {
    }

    public boolean shouldRenderOffScreen(DisplayTile tile) {
        return tile.data.getWidth() > 8.0f || tile.data.getHeight() > 8.0f;
    }

    public boolean shouldRender(DisplayTile tile, @NotNull Vec3 cameraPos) {
        return Vec3.m_82512_((Vec3i)tile.m_58899_()).m_82509_((Position)cameraPos, (double)tile.data.renderDistance);
    }

    public void render(DisplayTile tile, float partialTicks, PoseStack pose, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        TextureDisplay display = tile.requestDisplay();
        if (display == null || !WFConfig.keepsRendering()) {
            return;
        }
        RenderCore.cleanShader();
        RenderCore.bufferPrepare();
        RenderCore.cleanShader();
        RenderSystem.m_69478_();
        RenderSystem.m_69482_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Direction direction = this.direction(tile);
        Facing facing = Facing.get((Direction)direction);
        AlignedBox box = tile.getRenderBox();
        pose.m_85836_();
        pose.m_85837_(0.5, 0.5, 0.5);
        pose.m_85845_(facing.rotation().m_122270_((float)Math.toRadians(-tile.data.rotation)));
        pose.m_85837_(-0.5, -0.5, -0.5);
        if (facing.positive) {
            if (!tile.caps.invertedFace(tile)) {
                box.setMax(facing.axis, box.getMax(facing.axis) + tile.caps.growSize());
            } else {
                box.setMin(facing.axis, box.getMin(facing.axis) - tile.caps.growSize());
            }
        } else if (!tile.caps.invertedFace(tile)) {
            box.setMin(facing.axis, box.getMin(facing.axis) - tile.caps.growSize());
        } else {
            box.setMax(facing.axis, box.getMax(facing.axis) + tile.caps.growSize());
        }
        int brightness = tile.data.brightness;
        this.render(pose, tile, display, box, BoxFace.get((Facing)(tile.caps.invertedFace(tile) ? facing.opposite() : facing)), tile.data.alpha, brightness, brightness, brightness);
        pose.m_85849_();
        RenderCore.cleanShader();
        RenderSystem.m_69461_();
        RenderSystem.m_69465_();
        RenderSystem.m_69396_((int)0);
    }

    public void render(PoseStack pose, DisplayTile tile, TextureDisplay display, AlignedBox box, BoxFace face, int a, int r, int g, int b) {
        boolean flipX = this.flipX(tile);
        boolean flipY = this.flipY(tile);
        boolean front = this.inFront(tile);
        boolean back = this.inBack(tile);
        if (display.isLoading()) {
            RenderCore.bufferBegin();
            this.renderLoading(pose, tile, box, face, front, back, flipX, flipY);
            RenderCore.bufferEnd();
            return;
        }
        if (!display.canRender()) {
            return;
        }
        int tex = display.texture();
        if (tex != -1) {
            RenderCore.bufferBegin();
            RenderCore.bindTex(tex);
            if (front) {
                RenderCore.vertexF(pose, box, face, flipX, flipY, a, r, g, b);
            }
            if (back) {
                RenderCore.vertexB(pose, box, face, flipX, flipY, a, r, g, b);
            }
            RenderCore.bufferEnd();
        }
        if (display.isBuffering()) {
            RenderCore.bufferBegin();
            this.renderLoading(pose, tile, box, face, front, back, flipX, flipY);
            RenderCore.bufferEnd();
        }
    }

    public void renderLoading(PoseStack pose, DisplayTile tile, AlignedBox alignedBox, BoxFace face, boolean front, boolean back, boolean flipX, boolean flipY) {
        RenderCore.bindTex(LOADING_TEX.texture(DisplayControl.getTicks(), MathAPI.tickToMs((float)WaterFrames.deltaFrames()), true));
        AlignedBox box = new AlignedBox(alignedBox);
        Facing facing = face.getFacing();
        Axis one = facing.one();
        Axis two = facing.two();
        float width = box.getSize(one);
        float height = box.getSize(two);
        if (width > height) {
            float subtracts = (width - height) / 2.0f;
            float marginSubstract = height / 4.0f;
            box.setMin(one, box.getMin(one) + subtracts + marginSubstract);
            box.setMax(one, box.getMax(one) - subtracts - marginSubstract);
            box.setMin(two, box.getMin(two) + marginSubstract);
            box.setMax(two, box.getMax(two) - marginSubstract);
        } else if (height > width) {
            float subtracts = (height - width) / 2.0f;
            float marginSubstract = width / 4.0f;
            box.setMin(two, box.getMin(two) + subtracts + marginSubstract);
            box.setMax(two, box.getMax(two) - subtracts - marginSubstract);
            box.setMin(one, box.getMin(one) + marginSubstract);
            box.setMax(one, box.getMax(one) - marginSubstract);
        }
        if (facing.positive) {
            box.setMax(face.getFacing().axis, alignedBox.getMax(facing.axis) + (tile.caps.projects() ? -0.001f : 0.001f));
        } else {
            box.setMin(facing.axis, alignedBox.getMin(facing.axis) - (tile.caps.projects() ? -0.001f : 0.001f));
        }
        if (front) {
            RenderCore.vertexF(pose, box, face, flipX, flipY, 255, 255, 255, 255);
        }
        if (back) {
            RenderCore.vertexB(pose, box, face, flipX, flipY, 255, 255, 255, 255);
        }
    }

    public boolean inFront(DisplayTile tile) {
        return !tile.caps.projects() || tile.data.renderBothSides;
    }

    public boolean inBack(DisplayTile tile) {
        return tile.caps.projects() || tile.data.renderBothSides;
    }

    public boolean flipX(DisplayTile tile) {
        return tile.caps.projects() != tile.data.flipX;
    }

    public boolean flipY(DisplayTile tile) {
        return tile.data.flipY;
    }

    public Direction direction(DisplayTile tile) {
        return tile.getDirection();
    }
}

