/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.client.display;

import me.srrapero720.waterframes.client.display.TextureDisplay;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="waterframes", bus=Mod.EventBusSubscriber.Bus.FORGE)
@OnlyIn(value=Dist.CLIENT)
public class DisplayControl {
    private static final Marker IT = MarkerManager.getMarker((String)"DisplayControl");
    public static final Integer DEFAULT_SIZE = 32;
    private static volatile TextureDisplay[] displays = new TextureDisplay[DEFAULT_SIZE.intValue()];
    private static int position = 0;
    private static boolean checkSize = false;
    private static long ticks = 0L;
    private static boolean paused;

    public static void add(TextureDisplay display) {
        TextureDisplay[] freshMeal;
        if (checkSize) {
            if ((float)position / (float)displays.length <= 0.25f) {
                freshMeal = new TextureDisplay[displays.length / 2];
                System.arraycopy(displays, 0, freshMeal, 0, position);
                displays = freshMeal;
            }
            checkSize = false;
        }
        if (position >= displays.length) {
            freshMeal = new TextureDisplay[displays.length * 2];
            position = DisplayControl.copyData$resetPosition(displays, freshMeal);
            displays = freshMeal;
            checkSize = true;
        }
        if (paused) {
            display.setPauseMode(true);
        }
        DisplayControl.displays[DisplayControl.position++] = display;
    }

    public static void pause() {
        paused = true;
        for (int i = 0; i < position; ++i) {
            if (displays[i] == null) continue;
            displays[i].setPauseMode(true);
        }
    }

    public static void resume() {
        paused = false;
        for (int i = 0; i < position; ++i) {
            if (displays[i] == null) continue;
            displays[i].setPauseMode(false);
        }
    }

    public static void remove(int i) {
        if (i > displays.length) {
            return;
        }
        DisplayControl.displays[i] = null;
    }

    public static void remove(TextureDisplay obj) {
        if (obj == null) {
            return;
        }
        for (int i = 0; i < position; ++i) {
            if (obj != displays[i]) continue;
            DisplayControl.displays[i] = null;
            break;
        }
    }

    public static void release() {
        for (int i = 0; i < position; ++i) {
            if (displays[i] == null) continue;
            displays[i].release();
            DisplayControl.displays[i] = null;
        }
        displays = new TextureDisplay[DEFAULT_SIZE.intValue()];
        position = 0;
    }

    private static int copyData$resetPosition(TextureDisplay[] current, TextureDisplay[] target) {
        int freshPosition = 0;
        for (int i = 0; i < current.length; ++i) {
            if (current[i] == null) continue;
            target[freshPosition++] = current[i];
            current[i] = null;
        }
        return freshPosition;
    }

    public static void tick() {
        if (++ticks == Long.MAX_VALUE) {
            ticks = 0L;
        }
    }

    public static long getTicks() {
        return ticks;
    }

    @SubscribeEvent
    public static void onUnloadingLevel(WorldEvent.Unload event) {
        LevelAccessor level = event.getWorld();
        if (level != null && level.m_5776_()) {
            DisplayControl.release();
        }
    }

    @SubscribeEvent
    public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            DisplayControl.tick();
        }
    }

    public static void onClientPause(boolean paused) {
        if (paused) {
            DisplayControl.pause();
        } else {
            DisplayControl.resume();
        }
    }
}

