/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes;

import com.mojang.brigadier.CommandDispatcher;
import java.nio.file.Path;
import java.util.function.Supplier;
import me.srrapero720.waterframes.WFConfig;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.client.rendering.DisplayRenderer;
import me.srrapero720.waterframes.common.block.BigTvBlock;
import me.srrapero720.waterframes.common.block.DisplayBlock;
import me.srrapero720.waterframes.common.block.FrameBlock;
import me.srrapero720.waterframes.common.block.ProjectorBlock;
import me.srrapero720.waterframes.common.block.TvBlock;
import me.srrapero720.waterframes.common.block.entity.BigTvTile;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.block.entity.FrameTile;
import me.srrapero720.waterframes.common.block.entity.ProjectorTile;
import me.srrapero720.waterframes.common.block.entity.TvTile;
import me.srrapero720.waterframes.common.commands.WaterFramesCommand;
import me.srrapero720.waterframes.common.item.RemoteControl;
import me.srrapero720.waterframes.common.network.DisplayNetwork;
import me.srrapero720.waterframes.common.network.packets.ActivePacket;
import me.srrapero720.waterframes.common.network.packets.DataSyncPacket;
import me.srrapero720.waterframes.common.network.packets.LoopPacket;
import me.srrapero720.waterframes.common.network.packets.MutePacket;
import me.srrapero720.waterframes.common.network.packets.PausePacket;
import me.srrapero720.waterframes.common.network.packets.PermLevelPacket;
import me.srrapero720.waterframes.common.network.packets.TimePacket;
import me.srrapero720.waterframes.common.network.packets.VolumePacket;
import me.srrapero720.waterframes.common.network.packets.VolumeRangePacket;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.resource.PathResourcePack;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="waterframes", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WFRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"waterframes");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"waterframes");
    public static final DeferredRegister<BlockEntityType<?>> TILES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"waterframes");
    public static final CreativeModeTab TAB = new CreativeModeTab("waterframes"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)FRAME_ITEM.get());
        }
    };
    public static final RegistryObject<DisplayBlock> FRAME = BLOCKS.register("frame", FrameBlock::new);
    public static final RegistryObject<DisplayBlock> PROJECTOR = BLOCKS.register("projector", ProjectorBlock::new);
    public static final RegistryObject<DisplayBlock> TV = BLOCKS.register("tv", TvBlock::new);
    public static final RegistryObject<DisplayBlock> BIG_TV = BLOCKS.register("big_tv", BigTvBlock::new);
    public static final RegistryObject<Item> REMOTE_ITEM = ITEMS.register("remote", () -> new RemoteControl(new Item.Properties().m_41491_(TAB)));
    public static final RegistryObject<Item> FRAME_ITEM = ITEMS.register("frame", () -> new BlockItem((Block)FRAME.get(), WFRegistry.prop()));
    public static final RegistryObject<Item> PROJECTOR_ITEM = ITEMS.register("projector", () -> new BlockItem((Block)PROJECTOR.get(), WFRegistry.prop()));
    public static final RegistryObject<Item> TV_ITEM = ITEMS.register("tv", () -> new BlockItem((Block)TV.get(), WFRegistry.prop()));
    public static final RegistryObject<Item> BIG_TV_ITEM = ITEMS.register("big_tv", () -> new BlockItem((Block)BIG_TV.get(), WFRegistry.prop()));
    public static final RegistryObject<BlockEntityType<DisplayTile>> TILE_FRAME = WFRegistry.tile("frame", (BlockEntityType.BlockEntitySupplier<DisplayTile>)((BlockEntityType.BlockEntitySupplier)FrameTile::new), FRAME);
    public static final RegistryObject<BlockEntityType<DisplayTile>> TILE_PROJECTOR = WFRegistry.tile("projector", (BlockEntityType.BlockEntitySupplier<DisplayTile>)((BlockEntityType.BlockEntitySupplier)ProjectorTile::new), PROJECTOR);
    public static final RegistryObject<BlockEntityType<DisplayTile>> TILE_TV = WFRegistry.tile("tv", (BlockEntityType.BlockEntitySupplier<DisplayTile>)((BlockEntityType.BlockEntitySupplier)TvTile::new), TV);
    public static final RegistryObject<BlockEntityType<DisplayTile>> TILE_BIG_TV = WFRegistry.tile("big_tv", (BlockEntityType.BlockEntitySupplier<DisplayTile>)((BlockEntityType.BlockEntitySupplier)BigTvTile::new), BIG_TV);

    private static RegistryObject<BlockEntityType<DisplayTile>> tile(String name, BlockEntityType.BlockEntitySupplier<DisplayTile> creator, Supplier<DisplayBlock> block) {
        return TILES.register(name, () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)creator, (Block[])new Block[]{(Block)block.get()}).m_58966_(null));
    }

    private static Item.Properties prop() {
        return new Item.Properties().m_41487_(16).m_41491_(TAB).m_41497_(Rarity.EPIC);
    }

    public static void init(IEventBus bus) {
        BLOCKS.register(bus);
        ITEMS.register(bus);
        TILES.register(bus);
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        WaterFramesCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static class ModPackResources
    extends PathResourcePack {
        protected final IModFile modFile;
        protected final String sourcePath;

        public ModPackResources(String name, IModFile modFile, String sourcePath) {
            super(name, modFile.findResource(new String[]{sourcePath}));
            this.modFile = modFile;
            this.sourcePath = sourcePath;
        }

        @NotNull
        protected Path resolve(String ... paths) {
            String[] allPaths = new String[paths.length + 1];
            allPaths[0] = this.sourcePath;
            System.arraycopy(paths, 0, allPaths, 1, paths.length);
            return this.modFile.findResource(allPaths);
        }
    }

    public static class UnsupportedModException
    extends UnsupportedOperationException {
        private static final String MSG = "\u00c2\u00a7fMod \u00c2\u00a76'%s' \u00c2\u00a7fis not compatible with \u00c2\u00a7e'%s'\u00c2\u00a7f. please remove it";
        private static final String MSG_REASON = "\u00c2\u00a7fMod \u00c2\u00a76'%s' \u00c2\u00a7fis not compatible with \u00c2\u00a7e'%s' \u00c2\u00a7fbecause \u00c2\u00a7c%s \u00c2\u00a7fplease remove it";
        private static final String MSG_REASON_ALT = "\u00c2\u00a7fMod \u00c2\u00a76'%s' \u00c2\u00a7fis not compatible with \u00c2\u00a7e'%s' \u00c2\u00a7fbecause \u00c2\u00a7c%s \u00c2\u00a7fuse \u00c2\u00a7a'%s' \u00c2\u00a7finstead";

        public UnsupportedModException(String modid) {
            super(String.format(MSG, modid, "WATERFrAMES"));
        }

        public UnsupportedModException(String modid, String reason) {
            super(String.format(MSG_REASON, modid, "WATERFrAMES", reason));
        }

        public UnsupportedModException(String modid, String reason, String alternatives) {
            super(String.format(MSG_REASON_ALT, modid, "WATERFrAMES", reason, alternatives));
        }
    }

    @Mod.EventBusSubscriber(modid="waterframes", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void init(FMLCommonSetupEvent event) {
            DisplayNetwork.NET.registerType(DataSyncPacket.class, DataSyncPacket::new);
            DisplayNetwork.NET.registerType(PermLevelPacket.class, PermLevelPacket::new);
            DisplayNetwork.NET.registerType(ActivePacket.class, ActivePacket::new);
            DisplayNetwork.NET.registerType(LoopPacket.class, LoopPacket::new);
            DisplayNetwork.NET.registerType(MutePacket.class, MutePacket::new);
            DisplayNetwork.NET.registerType(PausePacket.class, PausePacket::new);
            DisplayNetwork.NET.registerType(TimePacket.class, TimePacket::new);
            DisplayNetwork.NET.registerType(VolumePacket.class, VolumePacket::new);
            DisplayNetwork.NET.registerType(VolumeRangePacket.class, VolumeRangePacket::new);
        }

        @SubscribeEvent
        public static void init(FMLClientSetupEvent e) {
            if (WaterFrames.isInstalled("mr_stellarity") && WFConfig.isDevMode()) {
                throw new UnsupportedModException("mr_stellarity", "breaks picture rendering, overwrites the Minecraft core shaders and i can't do nothing to avoid that");
            }
        }

        @SubscribeEvent
        public static void registerResourcePacks(AddPackFindersEvent e) {
            if (e.getPackType() == PackType.CLIENT_RESOURCES) {
                IModFile modFile = ModList.get().getModFileById("waterframes").getFile();
                e.addRepositorySource((consumer, constructor) -> consumer.accept(Pack.m_10430_((String)"waterframes/voxeloper", (boolean)false, () -> new ModPackResources("WaterFrames: Voxeloper", modFile, "resourcepacks/wf_voxeloper"), (Pack.PackConstructor)constructor, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10527_)));
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void registerTileRenderer(EntityRenderersEvent.RegisterRenderers e) {
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)TILE_FRAME.get()), DisplayRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)TILE_PROJECTOR.get()), DisplayRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)TILE_TV.get()), DisplayRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)TILE_BIG_TV.get()), DisplayRenderer::new);
        }
    }
}

