/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.tom.storagemod.gui.ContainerInventoryLink;
import com.tom.storagemod.network.IDataReceiver;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.util.RemoteConnections;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.lwjgl.glfw.GLFW;

public class GuiInventoryLink
extends AbstractContainerScreen<ContainerInventoryLink>
implements IDataReceiver {
    protected static final ResourceLocation creativeInventoryTabs = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final ResourceLocation gui = new ResourceLocation("toms_storage", "textures/gui/inventory_link.png");
    private static final int LINES = 7;
    private EditBox textF;
    private Map<UUID, RemoteConnections.Channel> connections = new HashMap<UUID, RemoteConnections.Channel>();
    private UUID selected;
    private int beaconLvl;
    private GuiButton createBtn;
    private GuiButton deleteBtn;
    private GuiButton publicBtn;
    private GuiButton remoteBtn;
    private List<ListEntry> listEntries = new ArrayList<ListEntry>();
    private List<UUID> sortedList = new ArrayList<UUID>();
    protected float currentScroll;
    protected boolean isScrolling;
    protected boolean wasClicking;

    public GuiInventoryLink(ContainerInventoryLink p_97741_, Inventory p_97742_, Component p_97743_) {
        super((AbstractContainerMenu)p_97741_, p_97742_, p_97743_);
    }

    @Override
    public void receive(CompoundTag tag) {
        ListTag list = tag.m_128437_("list", 10);
        RemoteConnections.load(list, this.connections);
        if (tag.m_128441_("selected")) {
            this.selected = tag.m_128342_("selected");
            RemoteConnections.Channel ch = this.connections.get(this.selected);
            this.textF.m_94144_(ch.displayName);
        } else {
            this.selected = null;
        }
        this.remoteBtn.state = tag.m_128471_("remote") ? 1 : 0;
        this.beaconLvl = tag.m_128451_("lvl");
        Comparator<Map.Entry> cmp = Comparator.comparing(e -> ((RemoteConnections.Channel)e.getValue()).publicChannel);
        cmp = cmp.thenComparing(e -> ((RemoteConnections.Channel)e.getValue()).displayName);
        this.sortedList = this.connections.entrySet().stream().sorted(cmp).map(Map.Entry::getKey).collect(Collectors.toList());
        this.update();
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int x, int y) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)gui);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(matrixStack, i, j, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_7027_(PoseStack p_97808_, int p_97809_, int p_97810_) {
        this.f_96547_.m_92889_(p_97808_, this.f_96539_, (float)this.f_97728_, (float)this.f_97729_, 0x404040);
        this.f_96547_.m_92883_(p_97808_, I18n.m_118938_((String)"ts.inventory_connector.beacon_level", (Object[])new Object[]{this.beaconLvl}), (float)this.f_97728_, (float)(this.f_97729_ + 10), 0x404040);
    }

    protected void m_7856_() {
        this.m_169413_();
        super.m_7856_();
        this.createBtn = new GuiButton(this.f_97735_ + 121, this.f_97736_ + 24, 0, () -> {
            RemoteConnections.Channel chn = new RemoteConnections.Channel(null, this.publicBtn.state == 1, this.textF.m_94155_());
            this.sendEdit(null, chn);
        });
        this.deleteBtn = new GuiButton(this.f_97735_ + 138, this.f_97736_ + 24, 1, () -> this.sendEdit(this.selected, null));
        this.publicBtn = new GuiButton(this.f_97735_ + 155, this.f_97736_ + 24, 2, () -> {
            if (this.selected != null && this.connections.containsKey(this.selected)) {
                RemoteConnections.Channel ch = this.connections.get(this.selected);
                if (ch.owner.equals(this.f_96541_.f_91074_.m_142081_())) {
                    ch.publicChannel = !ch.publicChannel;
                    this.publicBtn.state = ch.publicChannel ? 1 : 0;
                    this.sendEdit(this.selected, ch);
                }
            } else {
                this.publicBtn.state = this.publicBtn.state == 0 ? 1 : 0;
            }
        });
        this.remoteBtn = new GuiButton(this.f_97735_ + 155, this.f_97736_ + 7, 0, () -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("remote", this.remoteBtn.state == 0);
            NetworkHandler.sendDataToServer(tag);
        });
        this.remoteBtn.texY = 32;
        Objects.requireNonNull(this.f_96547_);
        this.textF = new EditBox(this.f_96547_, this.f_97735_ + 13, this.f_97736_ + 28, 105, 9, (Component)new TranslatableComponent("narrator.toms_storage.inventory_link_channel"));
        this.textF.m_94199_(50);
        this.textF.m_94182_(false);
        this.textF.m_94194_(true);
        this.textF.m_94202_(0xFFFFFF);
        this.textF.m_94144_("");
        this.textF.m_94151_(t -> {
            this.selected = null;
            for (Map.Entry<UUID, RemoteConnections.Channel> e : this.connections.entrySet()) {
                if (!e.getValue().displayName.equals(t)) continue;
                this.selected = e.getKey();
                break;
            }
            this.update();
        });
        this.m_142416_((GuiEventListener)this.textF);
        for (int i = 0; i < 7; ++i) {
            this.listEntries.add(new ListEntry(this.f_97735_ + 12, this.f_97736_ + 42 + i * 16, i));
        }
        this.update();
    }

    private void sendEdit(UUID id, RemoteConnections.Channel ch) {
        CompoundTag tag = new CompoundTag();
        if (id != null) {
            tag.m_128362_("id", id);
        }
        if (ch != null) {
            ch.saveNet(tag);
        }
        NetworkHandler.sendDataToServer(tag);
    }

    private void sendSelect(UUID id) {
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("id", id);
        tag.m_128379_("select", true);
        NetworkHandler.sendDataToServer(tag);
    }

    private void update() {
        if (this.selected != null && this.connections.containsKey(this.selected)) {
            boolean owner;
            this.deleteBtn.f_93623_ = true;
            RemoteConnections.Channel ch = this.connections.get(this.selected);
            this.publicBtn.state = ch.publicChannel ? 1 : 0;
            this.publicBtn.f_93623_ = owner = ch.owner.equals(this.f_96541_.f_91074_.m_142081_());
            this.createBtn.f_93623_ = false;
        } else {
            this.deleteBtn.f_93623_ = false;
            this.publicBtn.state = 0;
            this.createBtn.f_93623_ = true;
        }
    }

    private boolean needsScrollBars() {
        return this.sortedList.size() > 7;
    }

    public void m_6305_(PoseStack st, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(st);
        boolean flag = GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)0) != 0;
        int i = this.f_97735_;
        int j = this.f_97736_;
        int k = i + 122;
        int l = j + 42;
        int i1 = k + 14;
        int j1 = l + this.sortedList.size() * 16;
        if (!this.wasClicking && flag && mouseX >= k && mouseY >= l && mouseX < i1 && mouseY < j1) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseY - l) - 7.5f) / ((float)(j1 - l) - 15.0f);
            this.currentScroll = Mth.m_14036_((float)this.currentScroll, (float)0.0f, (float)1.0f);
        }
        super.m_6305_(st, mouseX, mouseY, partialTicks);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)creativeInventoryTabs);
        i = k;
        j = l;
        k = j1;
        this.m_93228_(st, i, j + (int)((float)(k - j - 17) * this.currentScroll), 232 + (this.needsScrollBars() ? 0 : 12), 0, 12, 15);
        this.m_7025_(st, mouseX, mouseY);
        if (this.publicBtn.m_198029_()) {
            this.m_96602_(st, (Component)new TranslatableComponent("tooltip.toms_storage.link_public_" + this.publicBtn.state), mouseX, mouseY);
        }
        if (this.remoteBtn.m_198029_()) {
            this.m_96602_(st, (Component)new TranslatableComponent("tooltip.toms_storage.link_remote_" + this.remoteBtn.state), mouseX, mouseY);
        }
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            this.m_7379_();
            return true;
        }
        return !this.textF.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) && !this.textF.m_94204_() ? super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) : true;
    }

    public boolean m_5534_(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.textF.m_5534_(p_charTyped_1_, p_charTyped_2_)) {
            return true;
        }
        return super.m_5534_(p_charTyped_1_, p_charTyped_2_);
    }

    public boolean m_6050_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        if (!this.needsScrollBars()) {
            return false;
        }
        int i = this.sortedList.size() - 7;
        this.currentScroll = (float)((double)this.currentScroll - p_mouseScrolled_5_ / (double)i);
        this.currentScroll = Mth.m_14036_((float)this.currentScroll, (float)0.0f, (float)1.0f);
        return true;
    }

    public class GuiButton
    extends Button {
        protected int tile;
        protected int state;
        protected int texX;
        protected int texY;

        public GuiButton(int x, int y, int tile, Runnable pressable) {
            super(x, y, 16, 16, null, b -> pressable.run());
            this.texX = 176;
            this.texY = 0;
            this.tile = tile;
            GuiInventoryLink.this.m_142416_((GuiEventListener)this);
        }

        public void setX(int i) {
            this.f_93620_ = i;
        }

        public void m_6303_(PoseStack st, int mouseX, int mouseY, float pt) {
            if (this.f_93624_) {
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)gui);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                this.f_93622_ = mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
                int i = this.m_7202_(this.m_198029_());
                this.m_93228_(st, this.f_93620_, this.f_93621_, this.texX + i * 16, 16, this.f_93618_, this.f_93619_);
                this.m_93228_(st, this.f_93620_, this.f_93621_, this.texX + this.tile * 16 + this.state * 16, this.texY, this.f_93618_, this.f_93619_);
            }
        }
    }

    public class ListEntry
    extends Button {
        private int id;

        public ListEntry(int x, int y, int id) {
            super(x, y, 106, 16, null, null);
            this.id = id;
            GuiInventoryLink.this.m_142416_((GuiEventListener)this);
        }

        public void m_6303_(PoseStack st, int mouseX, int mouseY, float pt) {
            UUID id;
            if (this.f_93624_ && (id = this.getId()) != null) {
                RemoteConnections.Channel chn = GuiInventoryLink.this.connections.get(id);
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)gui);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                this.f_93622_ = mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
                int i = this.m_7202_(this.m_198029_());
                this.m_93228_(st, this.f_93620_, this.f_93621_, id.equals(GuiInventoryLink.this.selected) ? 106 : 0, 166 + i * 16, this.f_93618_, this.f_93619_);
                this.m_93228_(st, this.f_93620_ + this.f_93618_ - 16, this.f_93621_, 208 + (chn.publicChannel ? 16 : 0), 0, 16, 16);
                int j = this.getFGColor();
                ListEntry.m_93208_((PoseStack)st, (Font)GuiInventoryLink.this.f_96547_, (String)chn.displayName, (int)(this.f_93620_ + this.f_93618_ / 2), (int)(this.f_93621_ + (this.f_93619_ - 8) / 2), (int)(j | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24));
            }
        }

        public void m_5691_() {
            UUID id = this.getId();
            if (id != null) {
                GuiInventoryLink.this.sendSelect(id);
            }
        }

        private UUID getId() {
            int i = GuiInventoryLink.this.sortedList.size() - 7;
            int j = (int)((double)(GuiInventoryLink.this.currentScroll * (float)i) + 0.5);
            if (j < 0) {
                j = 0;
            }
            if (this.id + j < GuiInventoryLink.this.sortedList.size()) {
                return GuiInventoryLink.this.sortedList.get(this.id + j);
            }
            return null;
        }
    }
}

