/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.pitchperfect.utils;

import com.aaronhowser1.pitchperfect.packets.ModPacketHandler;
import com.aaronhowser1.pitchperfect.packets.SpawnElectricPathPacket;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ServerUtils {
    public static Vec3 entityToVec3(LivingEntity livingEntity) {
        return new Vec3(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
    }

    public static List<LivingEntity> getNearbyLivingEntities(LivingEntity livingEntity, int range) {
        List entities = livingEntity.m_183503_().m_6249_((Entity)livingEntity, new AABB(livingEntity.m_20185_() - (double)range, livingEntity.m_20186_() - (double)range, livingEntity.m_20189_() - (double)range, livingEntity.m_20185_() + (double)range, livingEntity.m_20186_() + (double)range, livingEntity.m_20189_() + (double)range), e -> e instanceof LivingEntity);
        ArrayList<LivingEntity> livingEntities = new ArrayList<LivingEntity>();
        entities.forEach(entity -> livingEntities.add((LivingEntity)entity));
        return livingEntities;
    }

    @Nullable
    public static LivingEntity getNearestEntity(List<LivingEntity> entities, LivingEntity originEntity) {
        if (entities.isEmpty()) {
            return null;
        }
        LivingEntity nearestEntity = entities.get(0);
        for (LivingEntity checkedEntity : entities) {
            if (checkedEntity == originEntity || !(originEntity.m_20270_((Entity)nearestEntity) > originEntity.m_20270_((Entity)checkedEntity))) continue;
            nearestEntity = checkedEntity;
        }
        if (nearestEntity == originEntity) {
            return null;
        }
        return nearestEntity;
    }

    public static void spawnElectricParticleLine(Vec3 origin, Vec3 destination, ServerLevel serverLevel) {
        ModPacketHandler.messageNearbyPlayers(new SpawnElectricPathPacket(origin.m_7096_(), origin.m_7098_(), origin.m_7094_(), destination.m_7096_(), destination.m_7098_(), destination.m_7094_()), serverLevel, new Vec3(origin.m_7096_(), origin.m_7098_(), origin.m_7094_()), 64.0);
    }
}

