/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.pitchperfect.utils;

import com.aaronhowser1.pitchperfect.config.CommonConfigs;
import com.aaronhowser1.pitchperfect.utils.ClientUtils;
import com.aaronhowser1.pitchperfect.utils.ModScheduler;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;

public class ParticleLine {
    private final Vec3 originPositionVec;
    private final Vec3 destinationPositionVec;
    private final SimpleParticleType particleType;
    private int iteration;
    private final int particlesPerBlock;
    private final int totalTravelTime;

    public ParticleLine(Vec3 originPositionVec, Vec3 destinationPositionVec, SimpleParticleType particleType) {
        this.originPositionVec = originPositionVec;
        this.destinationPositionVec = destinationPositionVec;
        this.particleType = particleType;
        this.iteration = 1;
        this.particlesPerBlock = (Integer)CommonConfigs.ELECTRIC_PARTICLE_DENSITY.get();
        this.totalTravelTime = (Integer)CommonConfigs.ELECTRIC_JUMPTIME.get();
    }

    public void spawnWave() {
        if (this.particlesPerBlock == 0) {
            return;
        }
        Vec3 pathVector = this.originPositionVec.m_82505_(this.destinationPositionVec);
        float pathSize = (float)pathVector.m_82553_();
        int totalParticleCount = (int)(pathSize * (float)this.particlesPerBlock);
        float distanceBetweenParticles = 1.0f / (float)this.particlesPerBlock;
        Vec3 pathUnitVector = pathVector.m_82541_();
        Vec3 pathDeltaVector = new Vec3(pathUnitVector.m_7096_() * (double)distanceBetweenParticles, pathUnitVector.m_7098_() * (double)distanceBetweenParticles, pathUnitVector.m_7094_() * (double)distanceBetweenParticles);
        int timePerParticle = Math.max(this.totalTravelTime / totalParticleCount, 1);
        this.spawnNextParticle(totalParticleCount, pathDeltaVector, this.originPositionVec, distanceBetweenParticles, timePerParticle);
    }

    public void spawnNextParticle(int totalParticleCount, Vec3 deltaVector, Vec3 newOriginVec, float distanceBetween, int ticksPerParticle) {
        if (this.iteration <= totalParticleCount) {
            Vec3 particlePositionVector = newOriginVec.m_82549_(deltaVector);
            ClientUtils.spawnParticle(this.particleType, particlePositionVector.m_7096_(), particlePositionVector.m_7098_(), particlePositionVector.m_7094_(), 1.0f, 1.0f, 1.0f);
            ++this.iteration;
            ModScheduler.scheduleSynchronisedTask(() -> this.spawnNextParticle(totalParticleCount, deltaVector, particlePositionVector, distanceBetween, ticksPerParticle), ticksPerParticle);
        }
    }
}

