/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.pitchperfect.utils;

import com.aaronhowser1.pitchperfect.event.ModEvents;
import com.google.common.collect.HashMultimap;
import java.util.Iterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class ModScheduler {
    private static ScheduledExecutorService scheduler = null;
    private static final HashMultimap<Integer, Runnable> scheduledSynchTasks = HashMultimap.create();

    public static void scheduleSynchronisedTask(Runnable run, int ticks) {
        scheduledSynchTasks.put((Object)(ModEvents.tick + ticks), (Object)run);
    }

    public static void scheduleAsyncTask(Runnable run, int time, TimeUnit unit) {
        if (scheduler == null) {
            ModScheduler.serverStartupTasks();
        }
        scheduler.schedule(run, (long)time, unit);
    }

    public static void serverStartupTasks() {
        if (scheduler != null) {
            scheduler.shutdownNow();
        }
        scheduler = Executors.newScheduledThreadPool(1);
        ModScheduler.handleSyncScheduledTasks(null);
    }

    public static void serverShutdownTasks() {
        ModScheduler.handleSyncScheduledTasks(null);
        scheduler.shutdownNow();
        scheduler = null;
    }

    public static void handleSyncScheduledTasks(@Nullable Integer tick) {
        if (scheduledSynchTasks.containsKey((Object)tick)) {
            Iterator tasks;
            Iterator iterator = tasks = tick == null ? scheduledSynchTasks.values().iterator() : scheduledSynchTasks.get((Object)tick).iterator();
            while (tasks.hasNext()) {
                try {
                    ((Runnable)tasks.next()).run();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                tasks.remove();
            }
        }
    }
}

