/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.pitchperfect.packets;

import com.aaronhowser1.pitchperfect.packets.ModPacket;
import com.aaronhowser1.pitchperfect.utils.ParticleLine;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class SpawnElectricPathPacket
implements ModPacket {
    private final double x1;
    private final double y1;
    private final double z1;
    private final double x2;
    private final double y2;
    private final double z2;

    public SpawnElectricPathPacket(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.x1 = x1;
        this.y1 = y1;
        this.z1 = z1;
        this.x2 = x2;
        this.y2 = y2;
        this.z2 = z2;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.x1);
        buffer.writeDouble(this.y1);
        buffer.writeDouble(this.z1);
        buffer.writeDouble(this.x2);
        buffer.writeDouble(this.y2);
        buffer.writeDouble(this.z2);
    }

    public static SpawnElectricPathPacket decode(FriendlyByteBuf buffer) {
        return new SpawnElectricPathPacket(buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
    }

    @Override
    public void receiveMessage(Supplier<NetworkEvent.Context> context) {
        Vec3 originVec = new Vec3(this.x1, this.y1, this.z1);
        Vec3 destinationVec = new Vec3(this.x2, this.y2, this.z2);
        SpawnElectricPathPacket.spawnParticlePath(originVec, destinationVec);
        context.get().setPacketHandled(true);
    }

    private static void spawnParticlePath(Vec3 origin, Vec3 destination) {
        ParticleLine particleLine = new ParticleLine(origin, destination, ParticleTypes.f_123792_);
        particleLine.spawnWave();
    }
}

