/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.pitchperfect.item;

import com.aaronhowser1.pitchperfect.config.ClientConfigs;
import com.aaronhowser1.pitchperfect.config.CommonConfigs;
import com.aaronhowser1.pitchperfect.enchantment.BwaaapEnchantment;
import com.aaronhowser1.pitchperfect.enchantment.HealingBeatEnchantment;
import com.aaronhowser1.pitchperfect.enchantment.ModEnchantments;
import com.aaronhowser1.pitchperfect.item.ModCreativeModeTab;
import com.aaronhowser1.pitchperfect.packets.ModPacketHandler;
import com.aaronhowser1.pitchperfect.packets.SpawnNoteParticlePacket;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.Lazy;

public class InstrumentItem
extends Item {
    public final SoundEvent sound;
    private final Lazy<ImmutableSetMultimap<Attribute, AttributeModifier>> attributeModifiers;

    public InstrumentItem(SoundEvent s) {
        super(new Item.Properties().m_41487_(1).m_41491_(ModCreativeModeTab.MOD_TAB));
        this.sound = s;
        this.attributeModifiers = this.buildDefaultAttributes();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        Vec3 lookVector = player.m_20154_();
        float pitch = (float)lookVector.m_7098_();
        pitch = this.map(pitch, -1.0f, 1.0f, 0.5f, 2.0f);
        if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.BWAAAP.get()), (ItemStack)itemStack) != 0) {
            this.playSound(level, pitch, player.m_20185_(), player.m_20186_(), player.m_20189_(), ((Float)ClientConfigs.VOLUME.get()).floatValue() * 3.0f);
        } else {
            this.playSound(level, pitch, player.m_20185_(), player.m_20186_(), player.m_20189_(), ((Float)ClientConfigs.VOLUME.get()).floatValue());
        }
        Vec3 noteVector = lookVector;
        noteVector = interactionHand.equals((Object)InteractionHand.MAIN_HAND) ? lookVector.m_82524_(-0.5f) : lookVector.m_82524_(0.5f);
        if (!level.m_5776_()) {
            ModPacketHandler.messageNearbyPlayers(new SpawnNoteParticlePacket(this.sound.m_11660_(), pitch, (float)(player.m_20185_() + noteVector.m_7096_()), (float)(player.m_20188_() + noteVector.m_7098_()), (float)(player.m_20189_() + noteVector.m_7094_())), (ServerLevel)player.m_183503_(), new Vec3(player.m_20185_(), player.m_20186_(), player.m_20189_()), 128.0);
        }
        if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.HEALING_BEAT.get()), (ItemStack)itemStack) != 0) {
            HealingBeatEnchantment.heal((LivingEntity)player);
            float newPitch = pitch;
            HealingBeatEnchantment.getTargets((LivingEntity)player).forEach(target -> {
                if (!level.m_5776_()) {
                    ModPacketHandler.messageNearbyPlayers(new SpawnNoteParticlePacket(this.sound.m_11660_(), newPitch, (float)target.m_20185_(), (float)target.m_20188_(), (float)target.m_20189_()), (ServerLevel)target.m_183503_(), new Vec3(target.m_20185_(), target.m_20188_(), target.m_20189_()), 64.0);
                }
            });
            player.m_36335_().m_41524_((Item)this, (int)((float)HealingBeatEnchantment.getTargets((LivingEntity)player).size() * ((Float)CommonConfigs.HEAL_COOLDOWN_MULT.get()).floatValue()));
        }
        if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.BWAAAP.get()), (ItemStack)itemStack) != 0) {
            BwaaapEnchantment.knockback((LivingEntity)player);
            player.m_36335_().m_41524_((Item)this, BwaaapEnchantment.getTargets((LivingEntity)player).size() * (Integer)CommonConfigs.BWAAAP_COOLDOWN_MULT.get());
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    public void attack(Entity target) {
        int particleAmountUpperBound;
        int particleAmountLowerBound = (Integer)CommonConfigs.MIN_ATTACK_PARTICLES.get();
        if (particleAmountLowerBound < (particleAmountUpperBound = ((Integer)CommonConfigs.MAX_ATTACK_PARTICLES.get()).intValue())) {
            int randomAmount = (int)(Math.random() * (double)(particleAmountUpperBound - particleAmountLowerBound) + (double)particleAmountLowerBound);
            double entityWidth = target.m_20205_();
            double entityHeight = target.m_20206_();
            for (int note = 1; note <= randomAmount; ++note) {
                float randomPitch = (int)(Math.random() * 180.0) - 90;
                randomPitch = this.map(randomPitch, -90.0f, 90.0f, 2.0f, 0.5f);
                float noteX = (float)(target.m_20185_() + entityWidth * (Math.random() * 3.0 - 1.5));
                float noteZ = (float)(target.m_20189_() + entityWidth * (Math.random() * 3.0 - 1.5));
                float noteY = (float)(target.m_20186_() + entityHeight + (entityHeight * Math.random() * 1.5 - 0.75));
                ModPacketHandler.messageNearbyPlayers(new SpawnNoteParticlePacket(this.sound.m_11660_(), randomPitch, noteX, noteY, noteZ), (ServerLevel)target.m_183503_(), new Vec3((double)noteX, (double)noteY, (double)noteZ), 16.0);
                this.playSound(target.m_183503_(), randomPitch, noteX, noteY, noteZ, Math.max(((Float)ClientConfigs.VOLUME.get()).floatValue() / (float)randomAmount, ((Float)ClientConfigs.MIN_ATTACK_VOLUME.get()).floatValue()));
            }
        }
    }

    public float map(float value, float min1, float max1, float min2, float max2) {
        return min2 + (max2 - min2) * ((value - min1) / (max1 - min1));
    }

    private void playSound(Level level, float pitch, double x, double y, double z, float volume) {
        level.m_5594_(null, new BlockPos(x, y, z), this.sound, SoundSource.PLAYERS, volume, pitch);
    }

    public boolean m_8120_(ItemStack pStack) {
        return true;
    }

    public int m_6473_() {
        return 1;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.f_44672_.equals((Object)ModEnchantments.INSTRUMENT);
    }

    public float getAttackDamage() {
        return 0.01f;
    }

    protected Lazy<ImmutableSetMultimap<Attribute, AttributeModifier>> buildDefaultAttributes() {
        return Lazy.of(() -> ImmutableSetMultimap.of((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.getAttackDamage(), AttributeModifier.Operation.ADDITION)));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            HashMultimap newMap = HashMultimap.create();
            ImmutableSetMultimap attributes = (ImmutableSetMultimap)this.attributeModifiers.get();
            for (Map.Entry entry : attributes.entries()) {
                newMap.put((Object)((Attribute)entry.getKey()), (Object)((AttributeModifier)entry.getValue()));
            }
            return newMap;
        }
        return super.getAttributeModifiers(slot, stack);
    }
}

