/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.pitchperfect.event;

import com.aaronhowser1.pitchperfect.config.CommonConfigs;
import com.aaronhowser1.pitchperfect.enchantment.AndHisMusicWasElectricEnchantment;
import com.aaronhowser1.pitchperfect.enchantment.ModEnchantments;
import com.aaronhowser1.pitchperfect.item.InstrumentItem;
import com.aaronhowser1.pitchperfect.utils.ModScheduler;
import com.aaronhowser1.pitchperfect.utils.ServerUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pitchperfect")
public class ModEvents {
    public static int tick;

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity target = event.getEntityLiving();
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            Item item = attacker.m_21205_().m_41720_();
            if (item instanceof InstrumentItem) {
                InstrumentItem instrumentItem = (InstrumentItem)item;
                instrumentItem.attack((Entity)target);
            }
            boolean hasElectricEnchant = false;
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                for (ItemStack itemStack : player.m_150109_().f_35974_) {
                    if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.AND_HIS_MUSIC_WAS_ELECTRIC.get()), (ItemStack)itemStack) == 0) continue;
                    hasElectricEnchant = true;
                    break;
                }
            } else {
                for (ItemStack itemStack : attacker.m_20158_()) {
                    if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.AND_HIS_MUSIC_WAS_ELECTRIC.get()), (ItemStack)itemStack) == 0) continue;
                    hasElectricEnchant = true;
                    break;
                }
            }
            if (hasElectricEnchant && !attacker.m_183503_().m_5776_()) {
                ArrayList<LivingEntity> entitiesHit = new ArrayList<LivingEntity>();
                entitiesHit.add(target);
                entitiesHit.add(attacker);
                List<LivingEntity> nearbyLiving = ServerUtils.getNearbyLivingEntities(target, (Integer)CommonConfigs.ELECTRIC_RANGE.get());
                nearbyLiving.removeAll(entitiesHit);
                ArrayList<String> extraWhatevers = new ArrayList<String>();
                if (target instanceof Monster) {
                    nearbyLiving.removeIf(livingEntity -> !(livingEntity instanceof Monster));
                    extraWhatevers.add("target = monster");
                }
                if (attacker instanceof Monster) {
                    nearbyLiving.removeIf(livingEntity -> livingEntity instanceof Monster);
                    extraWhatevers.add("attacker = monster");
                }
                if (!nearbyLiving.isEmpty()) {
                    LivingEntity closestEntity = ServerUtils.getNearestEntity(nearbyLiving, target);
                    ServerUtils.spawnElectricParticleLine(new Vec3(target.m_20185_(), target.m_20186_(), target.m_20189_()), new Vec3(closestEntity.m_20185_(), closestEntity.m_20186_(), closestEntity.m_20189_()), (ServerLevel)closestEntity.m_183503_());
                    ModScheduler.scheduleSynchronisedTask(() -> {
                        Player player;
                        Item patt4439$temp;
                        if (attacker instanceof Player && (patt4439$temp = (player = (Player)attacker).m_21205_().m_41720_()) instanceof InstrumentItem) {
                            InstrumentItem instrumentItem = (InstrumentItem)patt4439$temp;
                            AndHisMusicWasElectricEnchantment.damage(target, closestEntity, entitiesHit, 1, event, extraWhatevers, instrumentItem);
                        } else {
                            AndHisMusicWasElectricEnchantment.damage(target, closestEntity, entitiesHit, 1, event, extraWhatevers, new InstrumentItem[0]);
                        }
                    }, (Integer)CommonConfigs.ELECTRIC_JUMPTIME.get());
                }
            }
        }
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ModScheduler.handleSyncScheduledTasks(++tick);
        }
    }
}

