/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.pitchperfect.enchantment;

import com.aaronhowser1.pitchperfect.config.CommonConfigs;
import com.aaronhowser1.pitchperfect.item.InstrumentItem;
import com.aaronhowser1.pitchperfect.packets.ModPacketHandler;
import com.aaronhowser1.pitchperfect.packets.SpawnElectricParticlePacket;
import com.aaronhowser1.pitchperfect.utils.ModScheduler;
import com.aaronhowser1.pitchperfect.utils.ServerUtils;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class AndHisMusicWasElectricEnchantment
extends Enchantment {
    protected AndHisMusicWasElectricEnchantment(Enchantment.Rarity pRarity, EnchantmentCategory pCategory, EquipmentSlot ... pApplicableSlots) {
        super(pRarity, pCategory, pApplicableSlots);
    }

    public int m_6183_(int pLevel) {
        return 15;
    }

    public int m_6175_(int pLevel) {
        return 55;
    }

    public static void damage(LivingEntity originEntity, LivingEntity targetEntity, List<LivingEntity> entitiesHit, int iteration, LivingHurtEvent event, List<String> extraWhatevers, InstrumentItem ... instrumentItems) {
        LivingEntity nextEntity;
        LivingEntity e = targetEntity;
        if (iteration > (Integer)CommonConfigs.ELECTRIC_MAX_JUMPS.get()) {
            return;
        }
        if (!e.m_6084_()) {
            return;
        }
        double entityWidth = e.m_20205_();
        double entityHeight = e.m_20206_();
        for (int p = 1; p <= Math.min(iteration, 5); ++p) {
            double X = e.m_20185_() + entityWidth * (Math.random() * 0.75 - 0.375);
            double Z = e.m_20189_() + entityWidth * (Math.random() * 0.75 - 0.375);
            double Y = e.m_20186_() + entityHeight + Math.min(2.0, (double)iteration * 0.05);
            ModPacketHandler.messageNearbyPlayers(new SpawnElectricParticlePacket(X, Y, Z), (ServerLevel)e.m_183503_(), new Vec3(X, Y, Z), 16.0);
        }
        float damageFactor = ((Float)CommonConfigs.ELECTRIC_DAMAGE_RETURNS.get()).floatValue() / (float)iteration;
        e.m_6469_(DamageSource.f_19306_, event.getAmount() * damageFactor);
        if (instrumentItems.length != 0) {
            instrumentItems[0].attack((Entity)e);
        }
        entitiesHit.add(e);
        List<LivingEntity> nextEntities = ServerUtils.getNearbyLivingEntities(e, (Integer)CommonConfigs.ELECTRIC_RANGE.get());
        nextEntities.removeAll(entitiesHit);
        nextEntities.remove(e);
        extraWhatevers.forEach(s -> {
            switch (s) {
                case "target = monster": {
                    nextEntities.removeIf(livingEntity -> !(livingEntity instanceof Monster));
                }
                case "attacker = monster": {
                    nextEntities.removeIf(livingEntity -> livingEntity instanceof Monster);
                }
            }
        });
        if (!nextEntities.isEmpty() && iteration + 1 <= (Integer)CommonConfigs.ELECTRIC_MAX_JUMPS.get() && (nextEntity = ServerUtils.getNearestEntity(nextEntities, e)).m_6084_()) {
            ServerUtils.spawnElectricParticleLine(new Vec3(e.m_20185_(), e.m_20186_(), e.m_20189_()), new Vec3(nextEntity.m_20185_(), nextEntity.m_20186_(), nextEntity.m_20189_()), (ServerLevel)e.m_183503_());
            ModScheduler.scheduleSynchronisedTask(() -> AndHisMusicWasElectricEnchantment.damage(e, nextEntity, entitiesHit, iteration + 1, event, extraWhatevers, instrumentItems), (Integer)CommonConfigs.ELECTRIC_JUMPTIME.get());
        }
    }
}

