/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.pitchperfect.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfigs {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Integer> MIN_ATTACK_PARTICLES;
    public static final ForgeConfigSpec.ConfigValue<Integer> MAX_ATTACK_PARTICLES;
    public static final ForgeConfigSpec.ConfigValue<Float> HEAL_AMOUNT;
    public static final ForgeConfigSpec.ConfigValue<Float> HEAL_COOLDOWN_MULT;
    public static final ForgeConfigSpec.ConfigValue<Integer> BWAAAP_RANGE;
    public static final ForgeConfigSpec.ConfigValue<Float> BWAAAP_STRENGTH;
    public static final ForgeConfigSpec.ConfigValue<Integer> BWAAAP_COOLDOWN_MULT;
    public static final ForgeConfigSpec.ConfigValue<Integer> ELECTRIC_RANGE;
    public static final ForgeConfigSpec.ConfigValue<Float> ELECTRIC_DAMAGE_RETURNS;
    public static final ForgeConfigSpec.ConfigValue<Integer> ELECTRIC_JUMPTIME;
    public static final ForgeConfigSpec.ConfigValue<Integer> ELECTRIC_MAX_JUMPS;
    public static final ForgeConfigSpec.ConfigValue<Integer> ELECTRIC_PARTICLE_DENSITY;

    static {
        BUILDER.push("Common configs for Pitch Perfect");
        MIN_ATTACK_PARTICLES = BUILDER.comment(" The minimum amount of notes to spawn, when attacking.").define("Minimum Attack Particles Amount", (Object)3);
        MAX_ATTACK_PARTICLES = BUILDER.comment(" The maximum amount of notes to spawn, when attacking.\n (Must be greater than minimum)").define("Maximum Attack Particles Amount", (Object)10);
        HEAL_AMOUNT = BUILDER.comment(" \n How much health is healed each time Healing Beat is used.").define("Healing Beat Amount", (Object)Float.valueOf(0.25f));
        HEAL_COOLDOWN_MULT = BUILDER.comment(" How many ticks to cool down for every mob healed.\n Example: healing 2 mobs has a default cooldown of 3 ticks.").define("Healing Cooldown Multiplier", (Object)Float.valueOf(1.5f));
        BWAAAP_RANGE = BUILDER.comment(" \nThe reach the BWAAAP enchantment has.").define("BWAAAP Range", (Object)5);
        BWAAAP_STRENGTH = BUILDER.comment(" The strength the BWAAAP enchantment has. Decreases with distance.\n Uses the equation:\n targetDistancePercentageToRange*strength").define("BWAAAP Strength", (Object)Float.valueOf(1.25f));
        BWAAAP_COOLDOWN_MULT = BUILDER.comment(" How many ticks to cool down for every mob BWAAAP'd.").define("BWAAAP Cooldown Multiplier", (Object)10);
        ELECTRIC_RANGE = BUILDER.comment(" \nThe range in blocks around the attacked mob that should be effected by the \"And His Music Was Electric\" enchantment.").define("Electric Range", (Object)5);
        ELECTRIC_DAMAGE_RETURNS = BUILDER.comment(" The rate of diminishing returns on each mob hit, as a percentage of the original. Uses equation\n    originalDamage * ( multiplier / entityNumber )\n where entityNumber is how many times it's jumped to a new entity").define("Electric Damage Multiplier", (Object)Float.valueOf(0.75f));
        ELECTRIC_JUMPTIME = BUILDER.comment(" How many ticks before the lightning jumps to the next entity.").define("Electric Jump Time", (Object)4);
        ELECTRIC_MAX_JUMPS = BUILDER.comment(" How many times the lightning can jump.\n Keep in mind that, after a certain amount of jumps, it deals less than half a heart.").defineInRange("Electric Jump Limit", Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
        ELECTRIC_PARTICLE_DENSITY = BUILDER.comment(" How many particles per block should be spawned along the lightning path.\n There's a minimum of 1 tick per particle, so higher numbers may cause the particles to take longer than the jump time.").defineInRange("Electric Particle Density", 3, 0, Integer.MAX_VALUE);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

