/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.loot;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DungeonChests
extends LootModifier {
    private final Item addition;

    protected DungeonChests(LootItemCondition[] conditionsIn, Item addition) {
        super(conditionsIn);
        this.addition = addition;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (context.m_78933_().nextFloat() < 0.5f) {
            generatedLoot.add(new ItemStack((ItemLike)this.addition, 1));
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<DungeonChests> {
        public DungeonChests read(ResourceLocation location, JsonObject object, LootItemCondition[] aiLootCondition) {
            Item addition = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(object.get("addition").getAsString()));
            return new DungeonChests(aiLootCondition, addition);
        }

        public JsonObject write(DungeonChests instance) {
            JsonObject jsonObject = this.makeConditions(instance.conditions);
            jsonObject.addProperty("addition", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)instance.addition).toString());
            return jsonObject;
        }
    }
}

