/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimlets.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.tooltips.ITooltipExtras;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsdim.dimension.data.ClientDimensionData;
import mcjty.rftoolsdim.modules.dimlets.DimletModule;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletSettings;
import mcjty.rftoolsdim.modules.dimlets.data.DimletTools;
import mcjty.rftoolsdim.modules.dimlets.data.DimletType;
import mcjty.rftoolsdim.modules.knowledge.data.DimletPattern;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeManager;
import mcjty.rftoolsdim.setup.Registration;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import org.apache.commons.lang3.tuple.Pair;

public class DimletItem
extends Item
implements ITooltipSettings,
ITooltipExtras {
    private final Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsdim.shiftmessage"), TooltipBuilder.parameter((String)"key", DimletItem::isReadyDimlet, DimletTools::getDimletDescription)}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"key", DimletItem::isReadyDimlet, DimletTools::getDimletDescription), TooltipBuilder.parameter((String)"rarity", DimletItem::isReadyDimlet, DimletTools::getDimletRarity), TooltipBuilder.parameter((String)"cost", DimletItem::isReadyDimlet, DimletTools::getDimletCost)});
    private final DimletType type;
    private final boolean isReady;

    public DimletItem(DimletType type, boolean isReady) {
        super(Registration.createStandardProperties());
        this.type = type;
        this.isReady = isReady;
    }

    public static boolean isReadyDimlet(ItemStack stack) {
        Item item = stack.m_41720_();
        return DimletItem.isReadyDimlet(item);
    }

    private static boolean isReadyDimlet(Item item) {
        if (item instanceof DimletItem) {
            return ((DimletItem)item).isReady;
        }
        return false;
    }

    public static boolean isEmptyDimlet(ItemStack stack) {
        if (stack.m_41720_() instanceof DimletItem) {
            if (stack.m_41720_() == DimletModule.EMPTY_DIMLET.get()) {
                return false;
            }
            return !((DimletItem)stack.m_41720_()).isReady;
        }
        return false;
    }

    public DimletType getType() {
        return this.type;
    }

    public static DimletType getType(ItemStack stack) {
        if (stack.m_41720_() instanceof DimletItem) {
            return ((DimletItem)stack.m_41720_()).getType();
        }
        return null;
    }

    public void m_7373_(@Nonnull ItemStack itemStack, Level world, @Nonnull List<Component> list, @Nonnull TooltipFlag flags) {
        super.m_7373_(itemStack, world, list, flags);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(Tools.getId((Item)this), itemStack, list, flags);
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            if (this == DimletModule.ADMIN_DIMLET.get()) {
                ItemStack stack = DimletTools.getDimletStack(new DimletKey(DimletType.ADMIN, "owner"));
                if (!stack.m_41619_()) {
                    items.add((Object)stack);
                }
                if (!(stack = DimletTools.getDimletStack(new DimletKey(DimletType.ADMIN, "cheater"))).m_41619_()) {
                    items.add((Object)stack);
                }
            } else if (this == DimletModule.DIGIT_DIMLET.get()) {
                for (int i = 0; i < 10; ++i) {
                    items.add((Object)DimletTools.getDimletStack(new DimletKey(DimletType.DIGIT, String.valueOf(i))));
                }
            } else {
                items.add((Object)new ItemStack((ItemLike)this));
            }
        }
    }

    public List<Pair<ItemStack, Integer>> getItems(ItemStack stack) {
        DimletKey key = DimletTools.getDimletKey(stack);
        if (key != null) {
            ItemStack essence;
            DimletSettings settings;
            ArrayList<Pair<ItemStack, Integer>> items = new ArrayList<Pair<ItemStack, Integer>>();
            items.add(Pair.of((Object)DimletTools.getNeededEnergyPart(key), (Object)-2));
            items.add(Pair.of((Object)DimletTools.getNeededMemoryPart(key), (Object)-2));
            long seed = ClientDimensionData.get().getWorldSeed();
            if (seed != -1L) {
                DimletPattern pattern = KnowledgeManager.get().getPattern(seed, key);
                DimletItem.addPatternItems(pattern, items);
            }
            if ((settings = DimletDictionary.get().getSettings(key)) != null && !(essence = DimletTools.getNeededEssence(key, settings)).m_41619_()) {
                items.add((Pair<ItemStack, Integer>)Pair.of((Object)essence, (Object)-1));
            }
            return items;
        }
        return Collections.emptyList();
    }

    public static void addPatternItems(DimletPattern pattern, List<Pair<ItemStack, Integer>> items) {
        if (pattern != null) {
            int cnt = pattern.count('*');
            if (cnt > 0) {
                items.add((Pair<ItemStack, Integer>)Pair.of((Object)new ItemStack((ItemLike)Registration.DIMENSIONAL_SHARD, cnt), (Object)-1));
            }
            if ((cnt = pattern.count('0')) > 0) {
                items.add((Pair<ItemStack, Integer>)Pair.of((Object)new ItemStack((ItemLike)DimletModule.COMMON_ESSENCE.get(), cnt), (Object)-1));
            }
            if ((cnt = pattern.count('1')) > 0) {
                items.add((Pair<ItemStack, Integer>)Pair.of((Object)new ItemStack((ItemLike)DimletModule.RARE_ESSENCE.get(), cnt), (Object)-1));
            }
            if ((cnt = pattern.count('2')) > 0) {
                items.add((Pair<ItemStack, Integer>)Pair.of((Object)new ItemStack((ItemLike)DimletModule.LEGENDARY_ESSENCE.get(), cnt), (Object)-1));
            }
        }
    }
}

