/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.blob.entities;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolsdim.dimension.data.DimensionData;
import mcjty.rftoolsdim.dimension.data.PersistantDimensionManager;
import mcjty.rftoolsdim.modules.blob.BlobConfig;
import mcjty.rftoolsdim.modules.dimlets.data.DimletRarity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.NetworkHooks;

public class DimensionalBlobEntity
extends Monster {
    private float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private final DimletRarity rarity;
    private AABB targetBox = null;
    private int tickCounter = 5;
    private static final TargetingConditions PREDICATE = TargetingConditions.m_148352_();

    public DimensionalBlobEntity(EntityType<? extends Monster> type, Level worldIn, DimletRarity rarity) {
        super(type, worldIn);
        this.rarity = rarity;
        this.calculateTargetBox(this.m_142469_());
    }

    private static int getDefaultMaxHealth(DimletRarity rarity) {
        return switch (rarity) {
            default -> throw new IncompatibleClassChangeError();
            case DimletRarity.COMMON -> (Integer)BlobConfig.BLOB_COMMON_HEALTH.get();
            case DimletRarity.RARE -> (Integer)BlobConfig.BLOB_RARE_HEALTH.get();
            case DimletRarity.LEGENDARY -> (Integer)BlobConfig.BLOB_LEGENDARY_HEALTH.get();
            case DimletRarity.UNCOMMON -> throw new IllegalStateException("There is no uncommon blob!");
        };
    }

    private int getRegenLevel() {
        return switch (this.rarity) {
            default -> throw new IncompatibleClassChangeError();
            case DimletRarity.COMMON -> (Integer)BlobConfig.BLOB_COMMON_REGEN.get();
            case DimletRarity.UNCOMMON -> throw new IllegalStateException("There is no uncommon blob!");
            case DimletRarity.RARE -> (Integer)BlobConfig.BLOB_RARE_REGEN.get();
            case DimletRarity.LEGENDARY -> (Integer)BlobConfig.BLOB_LEGENDARY_REGEN.get();
        };
    }

    public void m_8107_() {
        DimensionData data;
        super.m_8107_();
        if (!this.f_19853_.f_46443_ && (data = PersistantDimensionManager.get(this.f_19853_).getData(this.f_19853_.m_46472_().m_135782_())) != null && data.getEnergy() >= (Long)BlobConfig.BLOB_REGENERATION_LEVEL.get()) {
            --this.tickCounter;
            if (this.tickCounter <= 0) {
                this.tickCounter = 5;
                this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 20, this.getRegenLevel()));
            }
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(@Nonnull ServerLevelAccessor worldIn, @Nonnull DifficultyInstance difficultyIn, @Nonnull MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        AttributeInstance attr = this.m_21204_().m_22146_(Attributes.f_22276_);
        if (attr != null) {
            attr.m_22100_((double)DimensionalBlobEntity.getDefaultMaxHealth(this.rarity));
            this.m_21153_(DimensionalBlobEntity.getDefaultMaxHealth(this.rarity));
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static AttributeSupplier.Builder registerAttributes(DimletRarity rarity) {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, (double)DimensionalBlobEntity.getDefaultMaxHealth(rarity));
    }

    public float m_6134_() {
        return switch (this.rarity) {
            default -> throw new IncompatibleClassChangeError();
            case DimletRarity.COMMON, DimletRarity.UNCOMMON -> 1.5f;
            case DimletRarity.RARE -> 2.2f;
            case DimletRarity.LEGENDARY -> 4.7f;
        };
    }

    private void calculateTargetBox(AABB bb) {
        if (this.rarity != null) {
            double radius = switch (this.rarity) {
                default -> throw new IncompatibleClassChangeError();
                case DimletRarity.COMMON, DimletRarity.UNCOMMON -> 5.0;
                case DimletRarity.RARE -> 9.0;
                case DimletRarity.LEGENDARY -> 15.0;
            };
            this.targetBox = bb.m_82400_(radius);
        }
    }

    private void infectPlayer(Player player) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 100));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100));
        switch (this.rarity) {
            case COMMON: 
            case UNCOMMON: {
                break;
            }
            case RARE: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100));
                break;
            }
            case LEGENDARY: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 100));
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
            this.prevSquishFactor = this.squishFactor;
            if (this.f_19796_.nextFloat() < 0.03f) {
                this.squishAmount = -0.5f;
            } else if (this.f_19796_.nextFloat() < 0.03f) {
                this.squishAmount = 1.0f;
            }
            this.squishAmount *= 0.6f;
        } else if ((double)this.f_19796_.nextFloat() < 0.05) {
            List players = this.f_19853_.m_45955_(PREDICATE, (LivingEntity)this, this.targetBox);
            for (Player player : players) {
                this.infectPlayer(player);
            }
        }
    }

    public DimletRarity getRarity() {
        return this.rarity;
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

