/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.tools;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import mcjty.rftoolsdim.setup.RFToolsDimMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class PacketSyncDimensionListChanges {
    private final Set<ResourceKey<Level>> newDimensions;
    private final Set<ResourceKey<Level>> removedDimensions;

    public PacketSyncDimensionListChanges(Set<ResourceKey<Level>> newDimensions, Set<ResourceKey<Level>> removedDimensions) {
        this.newDimensions = newDimensions;
        this.removedDimensions = removedDimensions;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130130_(this.newDimensions.size());
        for (ResourceKey<Level> key : this.newDimensions) {
            buf.m_130085_(key.m_135782_());
        }
        buf.m_130130_(this.removedDimensions.size());
        for (ResourceKey<Level> key : this.removedDimensions) {
            buf.m_130085_(key.m_135782_());
        }
    }

    public PacketSyncDimensionListChanges(FriendlyByteBuf buf) {
        this.newDimensions = new HashSet<ResourceKey<Level>>();
        this.removedDimensions = new HashSet<ResourceKey<Level>>();
        int newDimensionCount = buf.m_130242_();
        for (int i = 0; i < newDimensionCount; ++i) {
            ResourceLocation worldID = buf.m_130281_();
            this.newDimensions.add((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)worldID));
        }
        int removedDimensionCount = buf.m_130242_();
        for (int i = 0; i < removedDimensionCount; ++i) {
            ResourceLocation worldID = buf.m_130281_();
            this.removedDimensions.add((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)worldID));
        }
    }

    public void handle(Supplier<NetworkEvent.Context> contextGetter) {
        NetworkEvent.Context context = contextGetter.get();
        context.enqueueWork(() -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                Set commandSuggesterLevels = player.f_108617_.m_105151_();
                commandSuggesterLevels.addAll(this.newDimensions);
                for (ResourceKey<Level> key : this.removedDimensions) {
                    commandSuggesterLevels.remove(key);
                }
            }
        });
        context.setPacketHandled(true);
    }

    public static void updateClientDimensionLists(Set<ResourceKey<Level>> newDimensions, Set<ResourceKey<Level>> removedDimensions) {
        RFToolsDimMessages.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new PacketSyncDimensionListChanges(newDimensions, removedDimensions));
    }
}

