/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.tools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.serialization.Lifecycle;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import mcjty.rftoolsdim.dimension.tools.PacketSyncDimensionListChanges;
import net.minecraft.core.BlockPos;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.DerivedLevelData;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;

public class DynamicDimensionManager {
    private static final Set<ResourceKey<Level>> VANILLA_WORLDS = ImmutableSet.of((Object)Level.f_46428_, (Object)Level.f_46429_, (Object)Level.f_46430_);
    private static Set<ResourceKey<Level>> pendingLevelsToUnregister = new HashSet<ResourceKey<Level>>();

    public static ServerLevel getOrCreateLevel(MinecraftServer server, ResourceKey<Level> levelKey, BiFunction<MinecraftServer, ResourceKey<LevelStem>, LevelStem> dimensionFactory) {
        Map map = server.forgeGetWorldMap();
        ServerLevel existingLevel = (ServerLevel)map.get(levelKey);
        if (existingLevel != null) {
            return existingLevel;
        }
        return DynamicDimensionManager.createAndRegisterWorldAndDimension(server, map, levelKey, dimensionFactory);
    }

    public static void markDimensionForUnregistration(MinecraftServer server, ResourceKey<Level> levelToRemove) {
        if (!VANILLA_WORLDS.contains(levelToRemove)) {
            pendingLevelsToUnregister.add(levelToRemove);
        }
    }

    public static Set<ResourceKey<Level>> getWorldsPendingUnregistration() {
        return Collections.unmodifiableSet(pendingLevelsToUnregister);
    }

    @Deprecated
    public static void unregisterScheduledDimensions(MinecraftServer server) {
        Set<ResourceKey<Level>> keysToRemove = pendingLevelsToUnregister;
        pendingLevelsToUnregister = new HashSet<ResourceKey<Level>>();
        WorldGenSettings worldGenSettings = server.m_129910_().m_5961_();
        HashSet<ResourceKey<Level>> removedLevelKeys = new HashSet<ResourceKey<Level>>();
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        for (ResourceKey<Level> levelKeyToRemove : keysToRemove) {
            ServerLevel removedLevel = (ServerLevel)server.forgeGetWorldMap().remove(levelKeyToRemove);
            if (removedLevel == null) continue;
            for (ServerPlayer player : Lists.newArrayList((Iterable)removedLevel.m_6907_())) {
                ResourceKey respawnKey = player.m_8963_();
                if (keysToRemove.contains(respawnKey)) {
                    respawnKey = Level.f_46428_;
                    player.m_9158_(Level.f_46428_, null, 0.0f, false, false);
                }
                if (respawnKey == null) {
                    respawnKey = Level.f_46428_;
                }
                ServerLevel destinationLevel = server.m_129880_(respawnKey);
                BlockPos destinationPos = player.m_8961_();
                if (destinationPos == null) {
                    destinationPos = destinationLevel.m_8900_();
                }
                float respawnAngle = player.m_8962_();
                player.m_8999_(destinationLevel, (double)destinationPos.m_123341_(), (double)destinationPos.m_123342_(), (double)destinationPos.m_123343_(), respawnAngle, 0.0f);
            }
            removedLevel.m_8643_(null, false, removedLevel.m_7441_());
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((LevelAccessor)removedLevel));
            WorldBorder overworldBorder = overworld.m_6857_();
            WorldBorder removedWorldBorder = removedLevel.m_6857_();
            List listeners = overworldBorder.f_61905_;
            BorderChangeListener targetListener = null;
            for (BorderChangeListener listener : listeners) {
                if (!(listener instanceof BorderChangeListener.DelegateBorderChangeListener) || removedWorldBorder != ((BorderChangeListener.DelegateBorderChangeListener)listener).f_61864_) continue;
                targetListener = listener;
                break;
            }
            if (targetListener != null) {
                overworldBorder.m_156096_(targetListener);
            }
            removedLevelKeys.add(levelKeyToRemove);
        }
        if (!removedLevelKeys.isEmpty()) {
            Registry oldRegistry = worldGenSettings.m_204655_();
            MappedRegistry newRegistry = new MappedRegistry(Registry.f_122820_, oldRegistry.m_194602_(), null);
            for (Map.Entry entry : oldRegistry.m_6579_()) {
                ResourceKey oldKey = (ResourceKey)entry.getKey();
                ResourceKey oldLevelKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)oldKey.m_135782_());
                LevelStem dimension = (LevelStem)entry.getValue();
                if (oldKey == null || dimension == null || removedLevelKeys.contains(oldLevelKey)) continue;
                Registry.m_194579_((Registry)newRegistry, (ResourceKey)oldKey, (Object)dimension);
            }
            worldGenSettings.f_64605_ = newRegistry;
            server.markWorldsDirty();
            PacketSyncDimensionListChanges.updateClientDimensionLists((Set<ResourceKey<Level>>)ImmutableSet.of(), removedLevelKeys);
        }
    }

    private static ServerLevel createAndRegisterWorldAndDimension(MinecraftServer server, Map<ResourceKey<Level>, ServerLevel> map, ResourceKey<Level> worldKey, BiFunction<MinecraftServer, ResourceKey<LevelStem>, LevelStem> dimensionFactory) {
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        ResourceKey dimensionKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122820_, (ResourceLocation)worldKey.m_135782_());
        LevelStem dimension = dimensionFactory.apply(server, (ResourceKey<LevelStem>)dimensionKey);
        ChunkProgressListener chunkProgressListener = server.f_129756_.m_9620_(11);
        Executor executor = server.f_129738_;
        LevelStorageSource.LevelStorageAccess anvilConverter = server.f_129744_;
        WorldData worldData = server.m_129910_();
        WorldGenSettings worldGenSettings = worldData.m_5961_();
        DerivedLevelData derivedLevelData = new DerivedLevelData(worldData, worldData.m_5996_());
        Registry dimensionRegistry = worldGenSettings.m_204655_();
        if (!(dimensionRegistry instanceof WritableRegistry)) {
            throw new IllegalStateException("Unable to register dimension '" + dimensionKey.m_135782_() + "'! Registry not writable!");
        }
        WritableRegistry writableRegistry = (WritableRegistry)dimensionRegistry;
        writableRegistry.m_203505_(dimensionKey, (Object)dimension, Lifecycle.stable());
        ServerLevel newWorld = new ServerLevel(server, executor, anvilConverter, (ServerLevelData)derivedLevelData, worldKey, dimension.m_204521_(), chunkProgressListener, dimension.m_63990_(), worldGenSettings.m_64668_(), BiomeManager.m_47877_((long)worldGenSettings.m_64619_()), (List)ImmutableList.of(), false);
        overworld.m_6857_().m_61929_((BorderChangeListener)new BorderChangeListener.DelegateBorderChangeListener(newWorld.m_6857_()));
        map.put(worldKey, newWorld);
        server.markWorldsDirty();
        MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((LevelAccessor)newWorld));
        PacketSyncDimensionListChanges.updateClientDimensionLists((Set<ResourceKey<Level>>)ImmutableSet.of(worldKey), (Set<ResourceKey<Level>>)ImmutableSet.of());
        return newWorld;
    }
}

