/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.terraintypes.generators;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import mcjty.rftoolsdim.dimension.terraintypes.RFToolsChunkGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.NotNull;

public class GridGenerator {
    public static CompletableFuture<ChunkAccess> fillFromNoise(ChunkAccess chunkAccess, RFToolsChunkGenerator generator) {
        ChunkPos chunkpos = chunkAccess.m_7697_();
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        Heightmap hmOcean = chunkAccess.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap hmWorld = chunkAccess.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        BlockState defaultBlock = generator.getDefaultBlock();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                int realx = chunkpos.f_45578_ * 16 + x;
                int realz = chunkpos.f_45579_ * 16 + z;
                if (realx % 32 == 0 && realz % 32 == 0) {
                    for (y = chunkAccess.m_141937_(); y < chunkAccess.m_151558_(); ++y) {
                        chunkAccess.m_6978_((BlockPos)mpos.m_122178_(x, y, z), defaultBlock, false);
                    }
                    hmOcean.m_64249_(x, chunkAccess.m_151558_() - 1, z, defaultBlock);
                    hmWorld.m_64249_(x, chunkAccess.m_151558_() - 1, z, defaultBlock);
                    continue;
                }
                if (realx % 32 != 0 && realz % 32 != 0) continue;
                for (y = chunkAccess.m_141937_(); y < chunkAccess.m_151558_(); y += 32) {
                    chunkAccess.m_6978_((BlockPos)mpos.m_122178_(x, y, z), defaultBlock, false);
                    hmOcean.m_64249_(x, y, z, defaultBlock);
                    hmWorld.m_64249_(x, y, z, defaultBlock);
                }
            }
        }
        return CompletableFuture.completedFuture(chunkAccess);
    }

    public static int getBaseHeight(int pX, int pZ, LevelHeightAccessor level) {
        if (pX % 32 == 0 && pZ % 32 == 0) {
            return level.m_151558_() - 1;
        }
        if (pX % 32 == 0 || pZ % 32 == 0) {
            return level.m_151558_() - 32;
        }
        return 0;
    }

    @NotNull
    public static NoiseColumn getBaseColumn(int pX, int pZ, LevelHeightAccessor level, RFToolsChunkGenerator generator) {
        Object[] states = new BlockState[GridGenerator.getBaseHeight(pX, pZ, level)];
        Arrays.fill(states, generator.getDefaultBlock());
        return new NoiseColumn(level.m_141937_(), (BlockState[])states);
    }
}

