/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.terraintypes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Stream;
import mcjty.rftoolsdim.compat.LostCityCompat;
import mcjty.rftoolsdim.dimension.data.DimensionSettings;
import mcjty.rftoolsdim.dimension.noisesettings.NoiseGeneratorSettingsBuilder;
import mcjty.rftoolsdim.dimension.noisesettings.NoiseSamplingSettingsBuilder;
import mcjty.rftoolsdim.dimension.noisesettings.NoiseSettingsBuilder;
import mcjty.rftoolsdim.dimension.noisesettings.NoiseSliderBuilder;
import mcjty.rftoolsdim.dimension.terraintypes.AttributeType;
import mcjty.rftoolsdim.dimension.terraintypes.TerrainType;
import mcjty.rftoolsdim.dimension.terraintypes.generators.FlatGenerator;
import mcjty.rftoolsdim.dimension.terraintypes.generators.GridGenerator;
import mcjty.rftoolsdim.dimension.terraintypes.generators.MazeGenerator;
import mcjty.rftoolsdim.dimension.terraintypes.generators.PlatformsGenerator;
import mcjty.rftoolsdim.dimension.terraintypes.generators.RavineGenerator;
import mcjty.rftoolsdim.dimension.terraintypes.generators.SpikesGenerator;
import mcjty.rftoolsdim.dimension.terraintypes.generators.WavesGenerator;
import mcjty.rftoolsdim.tools.PerlinNoiseGenerator14;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.jetbrains.annotations.NotNull;

public class RFToolsChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final Codec<RFToolsChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryOps.m_206832_((ResourceKey)Registry.f_211073_).forGetter(ins -> ins.f_207955_), (App)RegistryOps.m_206832_((ResourceKey)Registry.f_194568_).forGetter(ins -> ins.noises), (App)Codec.list((Codec)StructureSet.f_210002_).fieldOf("structures").forGetter(ins -> ins.overrideStructures), (App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(ins -> ins.f_62137_), (App)Codec.LONG.fieldOf("seed").stable().forGetter(ins -> ins.f_64333_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(ins -> ins.f_64318_), (App)DimensionSettings.SETTINGS_CODEC.fieldOf("dimsettings").forGetter(RFToolsChunkGenerator::getDimensionSettings)).apply((Applicative)instance, instance.stable(RFToolsChunkGenerator::new)));
    private final Registry<NormalNoise.NoiseParameters> noises;
    protected final DimensionSettings dimensionSettings;
    private final List<Holder<StructureSet>> overrideStructures;
    private PerlinNoiseGenerator14 perlinNoise = null;

    public RFToolsChunkGenerator(Registry<StructureSet> structureSetRegistry, Registry<NormalNoise.NoiseParameters> noiseRegistry, List<Holder<StructureSet>> overrideStructures, BiomeSource biomeSource, long seed, Holder<NoiseGeneratorSettings> settingsSupplier, DimensionSettings dimensionSettings) {
        super(structureSetRegistry, noiseRegistry, biomeSource, seed, settingsSupplier);
        this.noises = noiseRegistry;
        this.dimensionSettings = dimensionSettings;
        this.overrideStructures = overrideStructures;
    }

    public Stream<Holder<StructureSet>> m_207969_() {
        return this.overrideStructures.stream();
    }

    public void changeSettings(Consumer<NoiseSettingsBuilder> noiseBuilderConsumer, Consumer<NoiseSamplingSettingsBuilder> samplingSettingsBuilderConsumer, Consumer<NoiseSliderBuilder> topSliderBuilderConsumer, Consumer<NoiseSliderBuilder> bottomSliderBuilderConsumer) {
        NoiseGeneratorSettings settings = (NoiseGeneratorSettings)this.f_64318_.m_203334_();
        NoiseSamplingSettingsBuilder samplingSettingsBuilder = NoiseSamplingSettingsBuilder.create(settings.f_64439_().f_64509_());
        samplingSettingsBuilderConsumer.accept(samplingSettingsBuilder);
        NoiseSliderBuilder topSliderBuilder = NoiseSliderBuilder.create(settings.f_64439_().f_64510_());
        topSliderBuilderConsumer.accept(topSliderBuilder);
        NoiseSliderBuilder bottomSliderBuilder = NoiseSliderBuilder.create(settings.f_64439_().f_64511_());
        bottomSliderBuilderConsumer.accept(bottomSliderBuilder);
        NoiseSettingsBuilder noiseSettingsBuilder = NoiseSettingsBuilder.create(settings.f_64439_()).samplingSettings(samplingSettingsBuilder).topSlider(topSliderBuilder).bottomSlider(bottomSliderBuilder);
        noiseBuilderConsumer.accept(noiseSettingsBuilder);
        NoiseGeneratorSettings newsettings = NoiseGeneratorSettingsBuilder.create(settings).noiseSettings(noiseSettingsBuilder).build(this.dimensionSettings);
        this.f_64318_ = Holder.m_205709_((Object)newsettings);
    }

    public ChunkGenerator m_6819_(long pSeed) {
        return new RFToolsChunkGenerator((Registry<StructureSet>)this.f_207955_, this.noises, this.overrideStructures, this.f_62137_, pSeed, (Holder<NoiseGeneratorSettings>)this.f_64318_, this.dimensionSettings);
    }

    public NoiseGeneratorSettings getNoiseGeneratorSettings() {
        return (NoiseGeneratorSettings)this.f_64318_.m_203334_();
    }

    public long getSeed() {
        return this.f_64333_;
    }

    public BlockState getDefaultBlock() {
        return this.f_64316_;
    }

    public PerlinNoiseGenerator14 getPerlinNoise() {
        if (this.perlinNoise == null) {
            this.perlinNoise = new PerlinNoiseGenerator14(this.f_64333_, 4);
        }
        return this.perlinNoise;
    }

    private void checkForCities(WorldGenRegion region, TerrainType terrainType) {
        if (LostCityCompat.hasLostCities() && this.dimensionSettings.getCompiledDescriptor().getAttributeTypes().contains((Object)AttributeType.CITIES)) {
            LostCityCompat.registerDimension((ResourceKey<Level>)region.m_6018_().m_46472_(), LostCityCompat.getProfile(terrainType));
        }
    }

    public void m_183621_(WorldGenRegion level, StructureFeatureManager structureFeatureManager, ChunkAccess chunkAccess) {
        TerrainType terrainType = this.dimensionSettings.getCompiledDescriptor().getTerrainType();
        this.checkForCities(level, terrainType);
        if (terrainType != TerrainType.VOID && terrainType != TerrainType.FLAT) {
            super.m_183621_(level, structureFeatureManager, chunkAccess);
        }
    }

    public CompletableFuture<ChunkAccess> m_183489_(Executor executor, Blender blender, StructureFeatureManager structureFeatureManager, ChunkAccess chunkAccess) {
        TerrainType terrainType = this.dimensionSettings.getCompiledDescriptor().getTerrainType();
        return switch (terrainType) {
            case TerrainType.FLAT -> FlatGenerator.fillFromNoise(chunkAccess, this);
            case TerrainType.VOID -> CompletableFuture.completedFuture(chunkAccess);
            case TerrainType.WAVES -> WavesGenerator.fillFromNoise(chunkAccess, this);
            case TerrainType.SPIKES -> SpikesGenerator.fillFromNoise(chunkAccess, this);
            case TerrainType.GRID -> GridGenerator.fillFromNoise(chunkAccess, this);
            case TerrainType.PLATFORMS -> PlatformsGenerator.fillFromNoise(chunkAccess, this);
            case TerrainType.MAZE -> MazeGenerator.fillFromNoise(chunkAccess, this);
            case TerrainType.RAVINE -> RavineGenerator.fillFromNoise(chunkAccess, this);
            default -> super.m_183489_(executor, blender, structureFeatureManager, chunkAccess);
        };
    }

    public int m_142647_(int pX, int pZ, Heightmap.Types type, LevelHeightAccessor level) {
        TerrainType terrainType = this.dimensionSettings.getCompiledDescriptor().getTerrainType();
        return switch (terrainType) {
            case TerrainType.FLAT -> 119;
            case TerrainType.VOID -> level.m_141937_();
            case TerrainType.WAVES -> WavesGenerator.calculateWaveHeight(pX, pZ);
            case TerrainType.SPIKES -> SpikesGenerator.calculateSpikeHeight(pX, pZ, this.f_64333_);
            case TerrainType.GRID -> GridGenerator.getBaseHeight(pX, pZ, level);
            case TerrainType.PLATFORMS -> PlatformsGenerator.getBaseHeight(pX, pZ, level, this);
            case TerrainType.MAZE -> MazeGenerator.getBaseHeight(pX, pZ, level);
            case TerrainType.RAVINE -> RavineGenerator.getBaseHeight(pX, pZ, this);
            default -> super.m_142647_(pX, pZ, type, level);
        };
    }

    @NotNull
    public NoiseColumn m_141914_(int pX, int pZ, LevelHeightAccessor level) {
        TerrainType terrainType = this.dimensionSettings.getCompiledDescriptor().getTerrainType();
        return switch (terrainType) {
            case TerrainType.FLAT -> FlatGenerator.getBaseColumn(pX, pZ, level, this);
            case TerrainType.VOID -> new NoiseColumn(level.m_141937_(), new BlockState[0]);
            case TerrainType.WAVES -> WavesGenerator.getBaseColumn(pX, pZ, level, this);
            case TerrainType.SPIKES -> SpikesGenerator.getBaseColumn(pX, pZ, level, this);
            case TerrainType.GRID -> GridGenerator.getBaseColumn(pX, pZ, level, this);
            case TerrainType.PLATFORMS -> PlatformsGenerator.getBaseColumn(pX, pZ, level, this);
            case TerrainType.MAZE -> MazeGenerator.getBaseColumn(pX, pZ, level, this);
            case TerrainType.RAVINE -> RavineGenerator.getBaseColumn(pX, pZ, level, this);
            default -> super.m_141914_(pX, pZ, level);
        };
    }

    public DimensionSettings getDimensionSettings() {
        return this.dimensionSettings;
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }
}

