/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.features.instances;

import java.util.List;
import java.util.Random;
import mcjty.rftoolsdim.dimension.features.IFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;

public record SphereFeature(boolean hollow, boolean liquid) implements IFeature
{
    @Override
    public boolean generate(WorldGenLevel reader, ChunkGenerator generator, Random rand, BlockPos pos, List<BlockState> states, List<BlockState> liquids, long prime) {
        ChunkPos cp = new ChunkPos(pos);
        int chunkX = cp.f_45578_;
        int chunkZ = cp.f_45579_;
        int size = 1;
        BlockState filler = Blocks.f_50016_.m_49966_();
        boolean generated = false;
        for (int dx = -size; dx <= size; ++dx) {
            int cx = chunkX + dx;
            for (int dz = -size; dz <= size; ++dz) {
                int cz = chunkZ + dz;
                if (!SphereFeature.isFeatureCenter(reader, cx, cz, prime)) continue;
                if (this.liquid) {
                    int index = SphereFeature.getCenteredIndex(reader, cx, cz, prime, liquids.size());
                    filler = liquids.get(index);
                }
                this.generate(reader, chunkX, chunkZ, dx, dz, states, filler, prime);
                generated = true;
            }
        }
        return generated;
    }

    private void generate(WorldGenLevel world, int chunkX, int chunkZ, int dx, int dz, List<BlockState> states, BlockState filler, long prime) {
        long seeder = world.m_7328_() + (long)(chunkZ + dz) * 256203221L + (long)(chunkX + dx) * prime;
        Random random = new Random(seeder);
        random.nextFloat();
        int radius = random.nextInt(12) + 9;
        int centery = random.nextInt(60) + 40;
        int centerx = 8 + dx * 16;
        int centerz = 8 + dz * 16;
        double sqradius = radius * radius;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 16; ++x) {
            double dxdx = (x - centerx) * (x - centerx);
            for (int z = 0; z < 16; ++z) {
                double dzdz = (z - centerz) * (z - centerz);
                for (int y = centery - radius; y <= centery + radius; ++y) {
                    double dydy = (y - centery) * (y - centery);
                    double sqdist = dxdx + dydy + dzdz;
                    if (!(sqdist <= sqradius)) continue;
                    pos.m_122178_(chunkX * 16 + x, y, chunkZ * 16 + z);
                    if (!this.hollow || Math.sqrt(sqdist) >= (double)(radius - 2)) {
                        world.m_7731_((BlockPos)pos, IFeature.select(states, random), 0);
                        continue;
                    }
                    world.m_7731_((BlockPos)pos, filler, 0);
                }
            }
        }
    }

    private static int getCenteredIndex(WorldGenLevel world, int chunkX, int chunkZ, long prime, int max) {
        if (max == 1) {
            return 0;
        }
        Random random = new Random((long)chunkX * 3399018867L + (long)chunkZ * prime ^ world.m_7328_());
        random.nextFloat();
        return random.nextInt(max);
    }

    private static boolean isFeatureCenter(WorldGenLevel world, int chunkX, int chunkZ, long prime) {
        double factor = 0.05f;
        Random random = new Random((long)chunkX * prime + (long)chunkZ * 3399018867L ^ world.m_7328_());
        random.nextFloat();
        double value = random.nextFloat();
        return value < factor;
    }
}

