/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.features.buildings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import mcjty.rftoolsdim.dimension.features.IFeature;
import mcjty.rftoolsdim.dimension.terraintypes.TerrainType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BuildingTemplate {
    private final Map<Character, BlockState> palette = new HashMap<Character, BlockState>();
    private final Map<Character, BiConsumer<WorldGenLevel, BlockPos>> paletteSpecial = new HashMap<Character, BiConsumer<WorldGenLevel, BlockPos>>();
    private final List<Slice> slices = new ArrayList<Slice>();

    public BuildingTemplate palette(Character key, BlockState state) {
        this.palette.put(key, state);
        return this;
    }

    public BuildingTemplate palette(Character key, Block block) {
        this.palette.put(key, block.m_49966_());
        return this;
    }

    public BuildingTemplate palette(Character key, Supplier<Block> block) {
        this.palette.put(key, block.get().m_49966_());
        return this;
    }

    public BuildingTemplate palette(Character key, BiConsumer<WorldGenLevel, BlockPos> consumer) {
        this.paletteSpecial.put(key, consumer);
        return this;
    }

    public void generate(TerrainType type, WorldGenLevel reader, BlockPos pos, List<BlockState> states, GenerateFlag flag) {
        switch (flag) {
            case PLAIN: {
                break;
            }
            case FILLDOWN: {
                this.fillDown(reader, pos, states);
                break;
            }
            case FILLDOWN_IFNOTVOID: {
                if (type.isVoidLike()) break;
                this.fillDownIfNotVoid(reader, pos, states);
            }
        }
        int y = pos.m_123342_();
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        for (Slice slice : this.slices) {
            int z = pos.m_123343_();
            for (String row : slice.rows) {
                for (int x = 0; x < row.length(); ++x) {
                    mpos.m_122178_(pos.m_123341_() + x, y, z);
                    char key = row.charAt(x);
                    if (this.paletteSpecial.containsKey(Character.valueOf(key))) {
                        this.paletteSpecial.get(Character.valueOf(key)).accept(reader, (BlockPos)mpos);
                        continue;
                    }
                    reader.m_7731_((BlockPos)mpos, this.palette.get(Character.valueOf(key)), 0);
                }
                ++z;
            }
            ++y;
        }
    }

    private void fillDown(WorldGenLevel reader, BlockPos pos, List<BlockState> states) {
        int y = pos.m_123342_();
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        Slice slice = this.slices.get(0);
        int z = pos.m_123343_();
        for (String row : slice.rows) {
            block1: for (int x = 0; x < row.length(); ++x) {
                for (int yy = y - 1; yy > 1; --yy) {
                    mpos.m_122178_(pos.m_123341_() + x, yy, z);
                    BlockState state = reader.m_8055_((BlockPos)mpos);
                    if (!state.m_60795_()) continue block1;
                    BlockState blockState = IFeature.select(states, reader.m_5822_());
                    reader.m_7731_((BlockPos)mpos, blockState, 0);
                }
            }
            ++z;
        }
    }

    private void fillDownIfNotVoid(WorldGenLevel reader, BlockPos pos, List<BlockState> states) {
        int y = pos.m_123342_();
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        Slice slice = this.slices.get(0);
        int z = pos.m_123343_();
        for (String row : slice.rows) {
            block1: for (int x = 0; x < row.length(); ++x) {
                BlockState state;
                int yy;
                boolean isVoid = true;
                for (yy = y - 1; yy > reader.m_141937_() + 1; --yy) {
                    mpos.m_122178_(pos.m_123341_() + x, yy, z);
                    state = reader.m_8055_((BlockPos)mpos);
                    if (state.m_60795_()) continue;
                    isVoid = false;
                    break;
                }
                if (isVoid) continue;
                for (yy = y - 1; yy > reader.m_141937_() + 1; --yy) {
                    mpos.m_122178_(pos.m_123341_() + x, yy, z);
                    state = reader.m_8055_((BlockPos)mpos);
                    if (!state.m_60795_()) continue block1;
                    BlockState blockState = IFeature.select(states, reader.m_5822_());
                    reader.m_7731_((BlockPos)mpos, blockState, 0);
                }
            }
            ++z;
        }
    }

    public Slice slice() {
        Slice slice = new Slice();
        this.slices.add(slice);
        return slice;
    }

    public static enum GenerateFlag {
        PLAIN,
        FILLDOWN,
        FILLDOWN_IFNOTVOID;

    }

    public static class Slice {
        private final List<String> rows = new ArrayList<String>();

        public Slice row(String r) {
            this.rows.add(r);
            return this;
        }
    }
}

