/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.features;

import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import mcjty.rftoolsdim.dimension.DimensionConfig;
import mcjty.rftoolsdim.dimension.data.DimensionCreator;
import mcjty.rftoolsdim.dimension.descriptor.CompiledDescriptor;
import mcjty.rftoolsdim.dimension.descriptor.CompiledFeature;
import mcjty.rftoolsdim.dimension.features.FeatureType;
import mcjty.rftoolsdim.dimension.features.buildings.BuildingTemplate;
import mcjty.rftoolsdim.dimension.features.buildings.DimletHut;
import mcjty.rftoolsdim.dimension.features.buildings.SpawnHut;
import mcjty.rftoolsdim.dimension.features.buildings.SpawnPlatform;
import mcjty.rftoolsdim.dimension.terraintypes.RFToolsChunkGenerator;
import mcjty.rftoolsdim.dimension.terraintypes.TerrainType;
import mcjty.rftoolsdim.setup.Registration;
import mcjty.rftoolsdim.tools.Primes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class RFTFeature
extends Feature<NoneFeatureConfiguration> {
    public static final ResourceLocation RFTFEATURE_ID = new ResourceLocation("rftoolsdim", "rftfeature");
    public static Holder<PlacedFeature> RFTFEATURE_CONFIGURED;

    public static void registerConfiguredFeatures() {
        RFTFEATURE_CONFIGURED = PlacementUtils.m_206513_((String)"rftfeature", (Holder)Holder.m_205709_((Object)new ConfiguredFeature((Feature)((RFTFeature)((Object)Registration.RFTFEATURE.get())), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_)), (PlacementModifier[])new PlacementModifier[]{CountPlacement.m_191628_((int)1)});
    }

    public RFTFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        ChunkGenerator generator = context.m_159775_();
        BlockPos pos = context.m_159777_();
        Random rand = context.m_159776_();
        WorldGenLevel reader = context.m_159774_();
        if (generator instanceof RFToolsChunkGenerator) {
            RFToolsChunkGenerator chunkGenerator = (RFToolsChunkGenerator)generator;
            CompiledDescriptor compiledDescriptor = chunkGenerator.getDimensionSettings().getCompiledDescriptor();
            Set<CompiledFeature> features = compiledDescriptor.getFeatures();
            if (features.stream().anyMatch(f -> f.getFeatureType().equals((Object)FeatureType.NONE))) {
                return false;
            }
            boolean generatedSomething = false;
            int primeIndex = 0;
            for (CompiledFeature feature : features) {
                if (feature.getFeatureType().getFeature().generate(reader, generator, rand, pos, feature.getBlocks(), feature.getFluids(), Primes.PRIMES[primeIndex % Primes.PRIMES.length])) {
                    generatedSomething = true;
                }
                ++primeIndex;
            }
            ChunkPos cp = new ChunkPos(pos);
            TerrainType terrainType = compiledDescriptor.getTerrainType();
            List<BlockState> baseBlocks = Collections.singletonList(compiledDescriptor.getBaseBlock());
            if (cp.f_45578_ == 0 && cp.f_45579_ == 0) {
                int floorHeight = this.getFloorHeight(terrainType, reader, cp);
                DimensionCreator.get().registerPlatformHeight(reader.m_6018_().m_46472_().m_135782_(), floorHeight);
                if (floorHeight < generator.m_6337_()) {
                    ((SpawnHut)SpawnHut.SPAWN_HUT.get()).generate(terrainType, reader, new BlockPos(3, floorHeight, 3), baseBlocks, BuildingTemplate.GenerateFlag.PLAIN);
                } else {
                    ((SpawnPlatform)SpawnPlatform.SPAWN_PLATFORM.get()).generate(terrainType, reader, new BlockPos(3, floorHeight, 3), baseBlocks, BuildingTemplate.GenerateFlag.PLAIN);
                }
                generatedSomething = true;
            } else if ((double)rand.nextFloat() < (Double)DimensionConfig.DIMLET_HUT_CHANCE.get()) {
                ((DimletHut)DimletHut.DIMLET_HUT.get()).generate(terrainType, reader, new BlockPos(cp.m_45604_() + 4, this.getFloorHeight(terrainType, reader, cp), cp.m_45605_() + 4), baseBlocks, BuildingTemplate.GenerateFlag.FILLDOWN_IFNOTVOID);
                generatedSomething = true;
            }
            return generatedSomething;
        }
        return false;
    }

    private int getFloorHeight(TerrainType type, WorldGenLevel reader, ChunkPos cp) {
        int height0 = this.getHeightAt(type, reader, cp, 8, 8);
        int height1 = this.getHeightAt(type, reader, cp, 4, 4);
        int height2 = this.getHeightAt(type, reader, cp, 12, 4);
        int height3 = this.getHeightAt(type, reader, cp, 4, 12);
        int height4 = this.getHeightAt(type, reader, cp, 12, 12);
        return (height0 + height1 + height2 + height3 + height4) / 5;
    }

    private int getHeightAt(TerrainType type, WorldGenLevel reader, ChunkPos cp, int dx, int dz) {
        int height;
        if (type == TerrainType.CAVERN) {
            ChunkAccess chunk = reader.m_6325_(cp.f_45578_, cp.f_45579_);
            BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos(dx, 0, dz);
            for (height = (reader.m_141937_() + reader.m_151558_()) / 2; height > reader.m_141937_() && chunk.m_8055_((BlockPos)mpos.m_142448_(height)).m_60795_(); --height) {
            }
        } else {
            height = reader.m_6924_(Heightmap.Types.WORLD_SURFACE, cp.m_45604_() + dx, cp.m_45605_() + dz);
        }
        if (height <= reader.m_141937_() + 2 || height > reader.m_151558_() - 10) {
            height = 65;
        }
        return height;
    }
}

