/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.additional;

import java.util.HashMap;
import java.util.Map;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeSet;

public enum SkyDimletType {
    DEFAULT(0L, KnowledgeSet.SET1),
    END(1L, KnowledgeSet.SET1),
    INFERNAL(1024L, KnowledgeSet.SET5),
    BLACK(2048L, KnowledgeSet.SET5),
    STARS(4096L, KnowledgeSet.SET5),
    NEBULA(8192L, KnowledgeSet.SET5),
    NOCLOUDS(0x40000000L, KnowledgeSet.SET4),
    THICKBLACKFOG(0x10000000000L, KnowledgeSet.SET3),
    THICKREDFOG(0x20000000000L, KnowledgeSet.SET3),
    THICKWHITEFOG(0x40000000000L, KnowledgeSet.SET3),
    BLACKFOG(0x200000000000L, KnowledgeSet.SET3),
    REDFOG(0x400000000000L, KnowledgeSet.SET3),
    WHITEFOG(0x800000000000L, KnowledgeSet.SET3);

    private final long mask;
    private final KnowledgeSet set;
    private static final Map<String, SkyDimletType> BY_NAME;

    private SkyDimletType(long mask, KnowledgeSet set) {
        this.mask = mask;
        this.set = set;
    }

    public static String getDescription(long skyDimletTypes) {
        Object buf = "";
        for (SkyDimletType value : SkyDimletType.values()) {
            if (!value.match(skyDimletTypes)) continue;
            buf = (String)buf + value.name() + " ";
        }
        return buf;
    }

    public long getMask() {
        return this.mask;
    }

    public KnowledgeSet getKnowledgeSet() {
        return this.set;
    }

    public boolean match(long skyMask) {
        return (skyMask & this.mask) != 0L;
    }

    public static SkyDimletType byName(String name) {
        return BY_NAME.get(name.toLowerCase());
    }

    static {
        BY_NAME = new HashMap<String, SkyDimletType>();
        for (SkyDimletType type : SkyDimletType.values()) {
            BY_NAME.put(type.name().toLowerCase(), type);
        }
    }
}

