/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.compat;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.compat.theoneprobe.McJtyLibTOPDriver;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsdim.modules.essences.EssencesConfig;
import mcjty.rftoolsdim.modules.essences.EssencesModule;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class RFToolsDimensionsTOPDriver
implements TOPDriver {
    public static final RFToolsDimensionsTOPDriver DRIVER = new RFToolsDimensionsTOPDriver();
    private final Map<ResourceLocation, TOPDriver> drivers = new HashMap<ResourceLocation, TOPDriver>();

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
        TOPDriver driver;
        ResourceLocation id = Tools.getId((BlockState)blockState);
        if (!this.drivers.containsKey(id)) {
            if (blockState.m_60734_() == EssencesModule.BLOCK_ABSORBER.get()) {
                this.drivers.put(id, new BlockAbsorberDriver());
            } else if (blockState.m_60734_() == EssencesModule.FLUID_ABSORBER.get()) {
                this.drivers.put(id, new FluidAbsorberDriver());
            } else if (blockState.m_60734_() == EssencesModule.BIOME_ABSORBER.get()) {
                this.drivers.put(id, new BiomeAbsorberDriver());
            } else if (blockState.m_60734_() == EssencesModule.STRUCTURE_ABSORBER.get()) {
                this.drivers.put(id, new StructureAbsorberDriver());
            } else {
                this.drivers.put(id, new DefaultDriver());
            }
        }
        if ((driver = this.drivers.get(id)) != null) {
            driver.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        }
    }

    private static class BlockAbsorberDriver
    implements TOPDriver {
        private BlockAbsorberDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> {
                int absorbing = te.getAbsorbing();
                Block block = te.getAbsorbingBlock();
                int pct = ((Integer)EssencesConfig.maxBlockAbsorption.get() - absorbing) * 100 / (Integer)EssencesConfig.maxBlockAbsorption.get();
                ItemStack stack = new ItemStack((ItemLike)block, 1);
                if (!stack.m_41619_()) {
                    probeInfo.text((Component)ComponentFactory.literal((String)"Block: ").m_7220_((Component)ComponentFactory.translatable((String)stack.m_41778_())).m_130940_(ChatFormatting.GREEN)).horizontal().progress(pct, 100, probeInfo.defaultProgressStyle().suffix("%")).item(stack);
                }
            }, (String)"Bad tile entity!");
        }
    }

    private static class FluidAbsorberDriver
    implements TOPDriver {
        private FluidAbsorberDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> {
                int absorbing = te.getAbsorbing();
                Block block = te.getAbsorbingBlock();
                if (block != null) {
                    int pct = ((Integer)EssencesConfig.maxFluidAbsorption.get() - absorbing) * 100 / (Integer)EssencesConfig.maxFluidAbsorption.get();
                    probeInfo.text((Component)ComponentFactory.literal((String)"Fluid: ").m_7220_((Component)ComponentFactory.translatable((String)block.m_7705_())).m_130940_(ChatFormatting.GREEN)).horizontal().progress(pct, 100, probeInfo.defaultProgressStyle().suffix("%"));
                }
            }, (String)"Bad tile entity!");
        }
    }

    private static class BiomeAbsorberDriver
    implements TOPDriver {
        private BiomeAbsorberDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> {
                int absorbing = te.getAbsorbing();
                String biome = te.getAbsorbingBiome();
                int pct = ((Integer)EssencesConfig.maxBiomeAbsorption.get() - absorbing) * 100 / (Integer)EssencesConfig.maxBiomeAbsorption.get();
                ResourceLocation id = new ResourceLocation(biome);
                String trans = "biome." + id.m_135827_() + "." + id.m_135815_();
                probeInfo.text((Component)ComponentFactory.literal((String)"Biome: ").m_7220_((Component)ComponentFactory.translatable((String)trans)).m_130940_(ChatFormatting.GREEN)).horizontal().progress(pct, 100, probeInfo.defaultProgressStyle().suffix("%"));
            }, (String)"Bad tile entity!");
        }
    }

    private static class StructureAbsorberDriver
    implements TOPDriver {
        private StructureAbsorberDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> {
                int absorbing = te.getAbsorbing();
                String structure = te.getAbsorbingStructure();
                if (structure != null) {
                    int pct = ((Integer)EssencesConfig.maxStructureAbsorption.get() - absorbing) * 100 / (Integer)EssencesConfig.maxStructureAbsorption.get();
                    ResourceLocation id = new ResourceLocation(structure);
                    probeInfo.text((Component)ComponentFactory.literal((String)"Structure: ").m_7220_((Component)ComponentFactory.literal((String)id.m_135815_())).m_130940_(ChatFormatting.GREEN)).horizontal().progress(pct, 100, probeInfo.defaultProgressStyle().suffix("%"));
                }
            }, (String)"Bad tile entity!");
        }
    }

    private static class DefaultDriver
    implements TOPDriver {
        private DefaultDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
        }
    }
}

