/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.client.keymappings;

import com.mojang.blaze3d.platform.InputConstants;
import net.blay09.mods.balm.api.client.keymappings.BalmKeyMappings;
import net.blay09.mods.balm.api.client.keymappings.KeyConflictContext;
import net.blay09.mods.balm.mixin.KeyMappingAccessor;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import org.jetbrains.annotations.Nullable;

public class ForgeBalmKeyMappings
implements BalmKeyMappings {
    @Override
    public KeyMapping registerKeyMapping(String name, int keyCode, String category) {
        KeyMapping keyMapping = new KeyMapping(name, InputConstants.Type.KEYSYM, keyCode, category);
        ClientRegistry.registerKeyBinding((KeyMapping)keyMapping);
        return keyMapping;
    }

    @Override
    public KeyMapping registerKeyMapping(String name, InputConstants.Type type, int keyCode, String category) {
        KeyMapping keyMapping = new KeyMapping(name, type, keyCode, category);
        ClientRegistry.registerKeyBinding((KeyMapping)keyMapping);
        return keyMapping;
    }

    @Override
    public KeyMapping registerKeyMapping(String name, KeyConflictContext conflictContext, net.blay09.mods.balm.api.client.keymappings.KeyModifier modifier, int keyCode, String category) {
        KeyMapping keyMapping = new KeyMapping(name, ForgeBalmKeyMappings.toForge(conflictContext), ForgeBalmKeyMappings.toForge(modifier), InputConstants.Type.KEYSYM, keyCode, category);
        ClientRegistry.registerKeyBinding((KeyMapping)keyMapping);
        return keyMapping;
    }

    @Override
    public KeyMapping registerKeyMapping(String name, KeyConflictContext conflictContext, net.blay09.mods.balm.api.client.keymappings.KeyModifier modifier, InputConstants.Type type, int keyCode, String category) {
        KeyMapping keyMapping = new KeyMapping(name, ForgeBalmKeyMappings.toForge(conflictContext), ForgeBalmKeyMappings.toForge(modifier), type, keyCode, category);
        ClientRegistry.registerKeyBinding((KeyMapping)keyMapping);
        return keyMapping;
    }

    @Override
    public boolean isActiveAndMatches(@Nullable KeyMapping keyMapping, InputConstants.Key input) {
        return keyMapping != null && keyMapping.isActiveAndMatches(input);
    }

    @Override
    public boolean isActiveAndMatches(@Nullable KeyMapping keyMapping, int keyCode, int scanCode) {
        return keyMapping != null && keyMapping.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode));
    }

    @Override
    public boolean isActiveAndMatches(@Nullable KeyMapping keyMapping, InputConstants.Type type, int keyCode, int scanCode) {
        if (keyMapping == null) {
            return false;
        }
        return type == InputConstants.Type.MOUSE ? keyMapping.isActiveAndMatches(InputConstants.Type.MOUSE.m_84895_(keyCode)) : keyMapping.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode));
    }

    @Override
    public boolean isActiveAndWasPressed(@Nullable KeyMapping keyMapping) {
        return keyMapping != null && keyMapping.m_90859_();
    }

    private boolean isActiveAndMatchesStrictModifier(@Nullable KeyMapping keyMapping, int keyCode, int scanCode) {
        if (keyMapping == null) {
            return false;
        }
        if (keyMapping.getKeyModifier() == KeyModifier.NONE && (KeyModifier.SHIFT.isActive(keyMapping.getKeyConflictContext()) || KeyModifier.CONTROL.isActive(keyMapping.getKeyConflictContext()) || KeyModifier.ALT.isActive(keyMapping.getKeyConflictContext()))) {
            return false;
        }
        return keyMapping.m_90832_(keyCode, scanCode);
    }

    @Override
    public boolean isKeyDownIgnoreContext(@Nullable KeyMapping keyMapping) {
        if (keyMapping == null) {
            return false;
        }
        InputConstants.Key key = ((KeyMappingAccessor)keyMapping).getKey();
        return keyMapping.m_90857_() || key.m_84873_() != -1 && key.m_84868_() == InputConstants.Type.KEYSYM && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key.m_84873_());
    }

    @Override
    public boolean isActiveAndKeyDown(@Nullable KeyMapping keyMapping) {
        if (keyMapping == null) {
            return false;
        }
        InputConstants.Key key = ((KeyMappingAccessor)keyMapping).getKey();
        return keyMapping.m_90857_() || key.m_84873_() != -1 && key.m_84868_() == InputConstants.Type.KEYSYM && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key.m_84873_());
    }

    private static IKeyConflictContext toForge(KeyConflictContext context) {
        return switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case KeyConflictContext.UNIVERSAL -> net.minecraftforge.client.settings.KeyConflictContext.UNIVERSAL;
            case KeyConflictContext.GUI -> net.minecraftforge.client.settings.KeyConflictContext.GUI;
            case KeyConflictContext.INGAME -> net.minecraftforge.client.settings.KeyConflictContext.IN_GAME;
        };
    }

    private static KeyModifier toForge(net.blay09.mods.balm.api.client.keymappings.KeyModifier modifier) {
        return switch (modifier) {
            case net.blay09.mods.balm.api.client.keymappings.KeyModifier.SHIFT -> KeyModifier.SHIFT;
            case net.blay09.mods.balm.api.client.keymappings.KeyModifier.CONTROL -> KeyModifier.CONTROL;
            case net.blay09.mods.balm.api.client.keymappings.KeyModifier.ALT -> KeyModifier.ALT;
            default -> KeyModifier.NONE;
        };
    }
}

