/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ItemSmeltRod
extends Item {
    private static final int TIME = 10;
    private static final int COST = 300;
    private static final int COST_PER_TICK = 30;
    public static final Map<Player, SmeltData> playerData = new WeakHashMap<Player, SmeltData>();

    public ItemSmeltRod(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        return ItemUtils.m_150959_((Level)world, (Player)player, (InteractionHand)hand);
    }

    public void m_5929_(Level world, LivingEntity living, ItemStack stack, int time) {
        if (!(living instanceof Player)) {
            return;
        }
        Player p = (Player)living;
        SimpleContainer dummyInv = new SimpleContainer(1);
        if (!ManaItemHandler.instance().requestManaExactForTool(stack, p, 30, false)) {
            return;
        }
        BlockHitResult pos = ToolCommons.raytraceFromEntity((Entity)p, 32.0, false);
        if (pos.m_6662_() == HitResult.Type.BLOCK) {
            BlockState state = world.m_8055_(pos.m_82425_());
            dummyInv.m_6836_(0, new ItemStack((ItemLike)state.m_60734_()));
            world.m_7465_().m_44015_(RecipeType.f_44108_, (Container)dummyInv, p.f_19853_).map(arg_0 -> ItemSmeltRod.lambda$onUseTick$0((Container)dummyInv, arg_0)).filter(r -> !r.m_41619_() && r.m_41720_() instanceof BlockItem).ifPresent(result -> {
                SmeltData data;
                boolean decremented = false;
                if (playerData.containsKey(p) && (data = playerData.get(p)).equalPos(pos)) {
                    --data.progress;
                    decremented = true;
                    if (data.progress <= 0) {
                        if (!world.f_46443_) {
                            world.m_46597_(pos.m_82425_(), Block.m_49814_((Item)result.m_41720_()).m_49966_());
                            world.m_6263_(null, p.m_20185_(), p.m_20186_(), p.m_20189_(), ModSounds.smeltRod, SoundSource.PLAYERS, 1.0f, 1.0f);
                            world.m_6263_(null, p.m_20185_(), p.m_20186_(), p.m_20189_(), ModSounds.smeltRod2, SoundSource.PLAYERS, 1.0f, 1.0f);
                            ManaItemHandler.instance().requestManaExactForTool(stack, p, 30, true);
                            playerData.remove(p);
                            decremented = false;
                        }
                        WispParticleData data1 = WispParticleData.wisp(0.5f, 1.0f, 0.2f, 0.2f, 1.0f);
                        for (int i = 0; i < 25; ++i) {
                            double x = (double)pos.m_82425_().m_123341_() + Math.random();
                            double y = (double)pos.m_82425_().m_123342_() + Math.random();
                            double z = (double)pos.m_82425_().m_123343_() + Math.random();
                            world.m_7106_((ParticleOptions)data1, x, y, z, 0.0, (double)((float)(-Math.random()) / 10.0f), 0.0);
                        }
                    }
                }
                if (!decremented) {
                    playerData.put(p, new SmeltData(pos, ManaItemHandler.instance().hasProficiency(p, stack) ? 6 : 10));
                } else {
                    for (int i = 0; i < 2; ++i) {
                        double x = (double)pos.m_82425_().m_123341_() + Math.random();
                        double y = (double)pos.m_82425_().m_123342_() + Math.random();
                        double z = (double)pos.m_82425_().m_123343_() + Math.random();
                        WispParticleData data2 = WispParticleData.wisp(0.5f, 1.0f, 0.2f, 0.2f, 1.0f);
                        world.m_7106_((ParticleOptions)data2, x, y, z, 0.0, (double)((float)Math.random() / 10.0f), 0.0);
                    }
                    if (time % 10 == 0) {
                        world.m_6263_(null, p.m_20185_(), p.m_20186_(), p.m_20189_(), ModSounds.smeltRodSimmer, SoundSource.PLAYERS, (float)Math.random() / 2.0f + 0.5f, 1.0f);
                    }
                }
            });
        }
    }

    private static /* synthetic */ ItemStack lambda$onUseTick$0(Container dummyInv, SmeltingRecipe r) {
        return r.m_5874_(dummyInv);
    }

    static class SmeltData {
        public final BlockHitResult pos;
        public int progress;

        public SmeltData(BlockHitResult pos, int progress) {
            this.pos = pos;
            this.progress = progress;
        }

        public boolean equalPos(BlockHitResult pos) {
            return pos.m_82425_().equals((Object)this.pos.m_82425_());
        }
    }
}

