/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.state.enums.LuminizerVariant;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.render.tile.RenderTileSpecialFlower;
import vazkii.botania.common.block.BlockLightRelay;
import vazkii.botania.common.block.tile.TileLightRelay;
import vazkii.botania.common.item.equipment.bauble.ItemMonocle;

public class RenderTileLightRelay
implements BlockEntityRenderer<TileLightRelay> {
    private static final Map<LuminizerVariant, Material> sprites = (Map)Util.m_137469_(new EnumMap(LuminizerVariant.class), m -> {
        m.put(LuminizerVariant.DEFAULT, MiscellaneousModels.INSTANCE.lightRelayWorldIcon);
        m.put(LuminizerVariant.DETECTOR, MiscellaneousModels.INSTANCE.lightRelayDetectorWorldIcon);
        m.put(LuminizerVariant.FORK, MiscellaneousModels.INSTANCE.lightRelayForkWorldIcon);
        m.put(LuminizerVariant.TOGGLE, MiscellaneousModels.INSTANCE.lightRelayToggleWorldIcon);
    });

    public RenderTileLightRelay(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(@Nonnull TileLightRelay tile, float pticks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        LivingEntity view;
        BlockState state = tile.m_58900_();
        Minecraft mc = Minecraft.m_91087_();
        Entity entity = mc.m_91288_();
        if (entity instanceof LivingEntity && ItemMonocle.hasMonocle(view = (LivingEntity)entity) && RenderTileSpecialFlower.hasBindingAttempt(view, tile.m_58899_())) {
            RenderTileSpecialFlower.renderRadius(tile, ms, buffers, new RadiusDescriptor.Circle(tile.m_58899_(), 20.0));
        }
        TextureAtlasSprite iicon = sprites.get((Object)((BlockLightRelay)state.m_60734_()).variant).m_119204_();
        ms.m_85836_();
        ms.m_85837_(0.5, 0.3, 0.5);
        double time = (float)ClientTickHandler.ticksInGame + pticks;
        float scale = 0.75f;
        ms.m_85841_(scale, scale, scale);
        ms.m_85845_(mc.m_91290_().m_114470_());
        ms.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        float off = 0.25f;
        ms.m_85837_(0.0, (double)off, 0.0);
        ms.m_85845_(Vector3f.f_122227_.m_122240_((float)time));
        ms.m_85837_(0.0, (double)(-off), 0.0);
        VertexConsumer buffer = buffers.m_6299_(RenderHelper.LIGHT_RELAY);
        this.renderIcon(ms, buffer, iicon);
        ms.m_85849_();
    }

    private void renderIcon(PoseStack ms, VertexConsumer buffer, TextureAtlasSprite icon) {
        float size = icon.m_118410_() - icon.m_118409_();
        float pad = size / 8.0f;
        float f = icon.m_118409_() + pad;
        float f1 = icon.m_118410_() - pad;
        float f2 = icon.m_118411_() + pad;
        float f3 = icon.m_118412_() - pad;
        float f4 = 1.0f;
        float f5 = 0.5f;
        float f6 = 0.25f;
        Matrix4f mat = ms.m_85850_().m_85861_();
        buffer.m_85982_(mat, 0.0f - f5, 0.0f - f6, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(f, f3).m_5752_();
        buffer.m_85982_(mat, f4 - f5, 0.0f - f6, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(f1, f3).m_5752_();
        buffer.m_85982_(mat, f4 - f5, f4 - f6, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(f1, f2).m_5752_();
        buffer.m_85982_(mat, 0.0f - f5, f4 - f6, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(f, f2).m_5752_();
    }
}

