/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.world;

import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Counters;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.IWind;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.network.SmokePosMsg;
import com.endertech.minecraft.mods.adchimneys.particles.ModernSmokeParticle;
import com.endertech.minecraft.mods.adchimneys.smoke.Emitter;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;

public class SmokeLocations {
    protected static final CommonTime.Interval CLIENT_OUTLET_TTL = CommonTime.Interval.seconds((double)2.0);
    protected final LevelAccessor level;
    protected final GameTime clientUpdateInterval = GameTime.quaterSecond();
    protected final Map<BlockPos, Smoke> clientOutlets = new ConcurrentHashMap<BlockPos, Smoke>();
    protected final Map<BlockPos, SmokeOutlet> smokeOutlets = new ConcurrentHashMap<BlockPos, SmokeOutlet>();
    protected final Map<BlockPos, SmokeSource> smokeSources = new ConcurrentHashMap<BlockPos, SmokeSource>();
    protected final Map<ChunkPos, Set<BlockPos>> savedLocations = new ConcurrentHashMap<ChunkPos, Set<BlockPos>>();

    public SmokeLocations(LevelAccessor level) {
        this.level = level;
    }

    public LevelAccessor getLevel() {
        return this.level;
    }

    protected void removeSmokeSource(BlockPos sourcePos) {
        SmokeSource source = this.smokeSources.get(sourcePos);
        if (source != null) {
            this.removeFromOutlets(source);
            this.smokeSources.remove(sourcePos);
        }
    }

    protected void removeFromOutlets(SmokeSource source) {
        for (SmokeOutlet outlet : source.outlets) {
            outlet.sources.remove(source);
            if (!outlet.isEmpty()) continue;
            this.smokeOutlets.remove(outlet.position);
        }
        source.outlets.clear();
    }

    protected int addSmokeToOutlet(SmokeSource source, BlockPos outletPos, Smoke smoke, int amount) {
        if (amount <= 0) {
            return 0;
        }
        SmokeOutlet outlet = Optional.ofNullable(this.smokeOutlets.get(outletPos)).orElseGet(() -> new SmokeOutlet(outletPos));
        Smoke oldSmoke = outlet.getCombinedSmoke();
        Smoke newSmoke = oldSmoke.combine(smoke.withAmount(amount));
        int count = (int)(newSmoke.getAmount() - oldSmoke.getAmount());
        if (count > 0) {
            outlet.sources.put(source, smoke.withAmount(count));
            source.outlets.add(outlet);
            this.smokeOutlets.put(outletPos, outlet);
        }
        return count;
    }

    protected void tryPumpThrough(Supplier<List<BlockPos>> pumps, Outlets outlets) {
        if (outlets.hasSmokeToDistribute()) {
            GameWorld.SmokeContainers.pumpSmokeThrough(pumps.get(), (LevelAccessor)this.getLevel(), (int)outlets.smokeToDistribute(), (lev, pos, amount) -> {
                int count = this.addSmokeToOutlet(outlets.source, pos, outlets.smoke, amount);
                outlets.add(pos, count);
                return count;
            });
        }
    }

    protected void trySmokeAt(Supplier<List<BlockPos>> positions, Outlets outlets) {
        if (outlets.hasSmokeToDistribute()) {
            for (BlockPos pos : positions.get()) {
                int count = this.addSmokeToOutlet(outlets.source, pos, outlets.smoke, outlets.smokeToDistribute());
                outlets.add(pos, count);
                if (outlets.hasSmokeToDistribute()) continue;
                return;
            }
        }
    }

    public void updateSmokeSourceAt(BlockPos sourcePos) {
        Level level;
        if (this.level.m_5776_()) {
            return;
        }
        if (sourcePos instanceof BlockPos.MutableBlockPos) {
            return;
        }
        if (!GameWorld.isBlockLoaded((LevelReader)this.level, (BlockPos)sourcePos)) {
            return;
        }
        Emitter emitter = AdChimneys.getInstance().emitters.get((LevelReader)this.level, sourcePos).orElse(null);
        if (emitter == null) {
            this.removeSmokeSource(sourcePos);
            return;
        }
        SmokeSource source = this.smokeSources.computeIfAbsent(sourcePos, SmokeSource::new);
        LevelAccessor levelAccessor = this.level;
        if (levelAccessor instanceof Level && !source.updateInterval.pastIn(level = (Level)levelAccessor)) {
            return;
        }
        this.removeFromOutlets(source);
        Outlets outlets = new Outlets(source, emitter.getSmoke((LevelReader)this.level, sourcePos, true, true));
        WorldSearch.TileNeighbors neighbors = WorldSearch.TileNeighbors.from((LevelAccessor)this.level, (BlockPos)sourcePos, (Set)emitter.getRelatedBlocks());
        this.tryPumpThrough(() -> neighbors.getTopActivePumps(emitter.getMaxGapLength()), outlets);
        if (emitter.canEmitAside()) {
            this.tryPumpThrough(() -> ((WorldSearch.TileNeighbors)neighbors).getSideActivePumps(), outlets);
        }
        this.tryPumpThrough(() -> ((WorldSearch.TileNeighbors)neighbors).getBottomActivePumps(), outlets);
        this.trySmokeAt(() -> neighbors.getTopPassableChimneys(emitter.getMaxGapLength()).stream().map(pos -> GameWorld.SmokeContainers.getTopmostOpaqueChimney((LevelReader)this.level, (BlockPos)pos)).toList(), outlets);
        this.trySmokeAt(() -> neighbors.getSidePassableChimneys().stream().map(pos -> GameWorld.SmokeContainers.getTopmostOpaqueChimney((LevelReader)this.level, (BlockPos)pos)).toList(), outlets);
        this.trySmokeAt(() -> neighbors.getTopPipeOutlets(false, GameWorld.SmokeContainers::hasWayOut).stream().map(pos -> GameWorld.SmokeContainers.getTopmostOpaqueChimney((LevelReader)this.level, (BlockPos)pos)).toList(), outlets);
        if (emitter.emitWithoutChimney()) {
            this.trySmokeAt(() -> neighbors.getAboveBlocks(GameWorld.SmokeContainers::hasWayOut, 0), outlets);
            this.trySmokeAt(() -> List.of(sourcePos), outlets);
        }
        this.syncWithClients(outlets);
    }

    protected void syncWithClients(Outlets outlets) {
        LevelAccessor levelAccessor = this.level;
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            for (SmokeOutlet outlet : outlets.positions.stream().map(this.smokeOutlets::get).filter(Objects::nonNull).toList()) {
                Smoke smoke;
                if (outlet.isEmpty() || !(smoke = outlet.getCombinedSmoke()).hasParticles()) continue;
                new SmokePosMsg(outlet.position, smoke).sendTo(level);
                this.litRedstonePoweredBlock((LevelAccessor)level, outlet.position);
            }
        }
    }

    protected void litRedstonePoweredBlock(LevelAccessor level, BlockPos pos) {
        BlockState state;
        if (GameWorld.SmokeContainers.isChimney((LevelReader)level, (BlockPos)pos)) {
            pos = GameWorld.SmokeContainers.getTopmostChimney((LevelReader)level, (BlockPos)pos).m_7494_();
        }
        if (GameWorld.SmokeContainers.isPipe((LevelReader)level, (BlockPos)pos)) {
            pos = GameWorld.SmokeContainers.getTopmostPipe((LevelReader)level, (BlockPos)pos).m_7494_();
        }
        if ((state = level.m_8055_(pos)).m_61138_((Property)BlockStateProperties.f_61443_)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 2);
            int delay = (int)GameTime.inServerTicks((CommonTime.Interval)CommonTime.Interval.seconds((double)2.0));
            level.m_186460_(pos, state.m_60734_(), delay);
        }
    }

    public void onServerTick() {
        for (SmokeSource source : this.smokeSources.values()) {
            Level level;
            LevelAccessor levelAccessor = this.level;
            if (!(levelAccessor instanceof Level) || !source.updateInterval.pastIn(level = (Level)levelAccessor)) continue;
            this.updateSmokeSourceAt(source.position);
        }
    }

    public void onClientTick() {
        Level level;
        LevelAccessor levelAccessor = this.level;
        if (levelAccessor instanceof Level && (level = (Level)levelAccessor).m_5776_() && this.clientUpdateInterval.pastIn(level)) {
            Iterator<Map.Entry<BlockPos, Smoke>> iterator = this.clientOutlets.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<BlockPos, Smoke> entry = iterator.next();
                BlockPos pos = entry.getKey();
                Smoke smoke = entry.getValue();
                double distance = ForgeEntity.getCurPosition((Entity)Minecraft.m_91087_().m_91288_()).distance(Vect3d.from((BlockPos)pos));
                if (smoke.hasParticles() && smoke.getLifeTime().lessThan(CLIENT_OUTLET_TTL) && distance <= (double)((Integer)Smoke.maxRenderDistance.get()).intValue() && GameWorld.isBlockLoaded((LevelReader)level, (BlockPos)pos) && (((Boolean)Smoke.emitWithoutChimney.get()).booleanValue() || GameWorld.SmokeContainers.isChimney((LevelReader)level, (BlockPos)pos))) {
                    float factor = this.getParticlesReductionFactor();
                    IWind wind = GameWorld.getWindAt((Level)level, (BlockPos)pos);
                    ModernSmokeParticle.generate(level, wind, smoke, pos, factor);
                    continue;
                }
                iterator.remove();
            }
        }
    }

    public void putClientOutlet(BlockPos pos, Smoke smoke) {
        this.clientOutlets.put(pos, smoke);
    }

    protected float getParticlesReductionFactor() {
        float factor = 1.0f;
        int particlesCount = GameWorld.getData((LevelAccessor)this.level).smokeParticlesCount;
        if (particlesCount > (Integer)Smoke.maxRenderedParticlesAmount.get()) {
            factor = (float)((Integer)Smoke.maxRenderedParticlesAmount.get()).intValue() / (float)particlesCount * 0.5f;
        }
        return factor;
    }

    public int getOutletsTotal() {
        return this.smokeOutlets.size();
    }

    public int getSourcesTotal() {
        return this.smokeSources.size();
    }

    public void removeAllSmokeSourcesIn(ChunkAccess chunk) {
        ChunkPos chunkPos = chunk.m_7697_();
        Set<BlockPos> locations = this.getSmokeSourceLocationsIn(chunk);
        locations.forEach(this::removeSmokeSource);
        this.savedLocations.put(chunkPos, locations);
    }

    protected Set<BlockPos> getSmokeSourceLocationsIn(ChunkAccess chunk) {
        ChunkPos chunkPos = chunk.m_7697_();
        return this.smokeSources.keySet().stream().filter(pos -> chunkPos.equals((Object)new ChunkPos(pos))).collect(Collectors.toSet());
    }

    public void readSmokeSourceLocationsFrom(ChunkAccess chunk, CompoundTag compound) {
        String key = "smoke_source_locations";
        if (compound.m_128425_("smoke_source_locations", 12)) {
            Set locations = Arrays.stream(compound.m_128467_("smoke_source_locations")).mapToObj(BlockPos::m_122022_).collect(Collectors.toSet());
            this.savedLocations.put(chunk.m_7697_(), locations);
        }
    }

    public void writeSmokeSourceLocationsTo(ChunkAccess chunk, CompoundTag compound) {
        HashSet<BlockPos> locations = new HashSet<BlockPos>();
        Optional.ofNullable(this.savedLocations.get(chunk.m_7697_())).ifPresent(locations::addAll);
        locations.addAll(this.getSmokeSourceLocationsIn(chunk));
        if (!locations.isEmpty()) {
            compound.m_128428_("smoke_source_locations", locations.stream().map(BlockPos::m_121878_).toList());
        }
    }

    public void updateSmokeSourcesIn(ChunkAccess chunk) {
        HashSet locations = new HashSet();
        Optional.ofNullable(this.savedLocations.remove(chunk.m_7697_())).ifPresent(locations::addAll);
        locations.addAll(chunk.m_5928_());
        locations.forEach(this::updateSmokeSourceAt);
    }

    protected static class SmokeSource {
        public final BlockPos position;
        public final GameTime updateInterval = GameTime.second();
        protected final Set<SmokeOutlet> outlets = new HashSet<SmokeOutlet>();

        SmokeSource(BlockPos position) {
            this.position = position;
        }
    }

    protected static class SmokeOutlet {
        public final BlockPos position;
        protected final Map<SmokeSource, Smoke> sources = new HashMap<SmokeSource, Smoke>();

        SmokeOutlet(BlockPos position) {
            this.position = position;
        }

        boolean isEmpty() {
            return this.sources.isEmpty();
        }

        Smoke getCombinedSmoke() {
            Smoke combinedSmoke = new Smoke();
            for (Smoke smoke : this.sources.values()) {
                combinedSmoke = combinedSmoke.combine(smoke);
            }
            return combinedSmoke;
        }
    }

    protected static class Outlets {
        protected final SmokeSource source;
        protected final Smoke smoke;
        protected final Set<BlockPos> positions = new HashSet<BlockPos>();
        protected final Counters.IntCounter counter;

        public Outlets(SmokeSource source, Smoke smoke) {
            this.source = source;
            this.smoke = smoke;
            this.counter = Counters.fromZeroTo((int)((int)smoke.getAmount()));
        }

        public boolean add(BlockPos pos, int smokeAmount) {
            if (smokeAmount > 0 && this.counter.add(smokeAmount)) {
                this.positions.add(pos);
                return true;
            }
            return false;
        }

        public boolean hasSmokeToDistribute() {
            return this.smokeToDistribute() > 0;
        }

        public int smokeToDistribute() {
            return this.counter.getDistToMaximum();
        }
    }
}

