/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.items;

import com.endertech.minecraft.forge.items.ForgeItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolAction;
import org.jetbrains.annotations.Nullable;

public class Paintbrush
extends Item {
    public static ForgeConfigSpec.ConfigValue<Boolean> requiresWaterBucket;
    public static ForgeConfigSpec.ConfigValue<Boolean> requiresDye;

    public Paintbrush(Item.Properties pProperties) {
        super(pProperties);
    }

    public static boolean in(Player player, InteractionHand hand) {
        return Paintbrush.in(player.m_21120_(hand));
    }

    public static boolean in(ItemStack stack) {
        String name = ForgeItem.getRegistryName((Item)stack.m_41720_()).m_135815_();
        return name.contains("paint") && name.contains("brush");
    }

    public static boolean hasAllRequiredMaterials(Player player) {
        if (player.m_150110_().f_35937_) {
            return true;
        }
        Inventory inventory = player.m_150109_();
        boolean hasWater = (Boolean)requiresWaterBucket.get() == false || ForgeItem.indexIn((Inventory)inventory, stack -> {
            BucketItem bucket;
            Item patt1986$temp = stack.m_41720_();
            return patt1986$temp instanceof BucketItem && (bucket = (BucketItem)patt1986$temp).getFluid().m_76145_().m_205070_(FluidTags.f_13131_);
        }).isPresent();
        boolean hasDye = (Boolean)requiresDye.get() == false || ForgeItem.indexIn((Inventory)inventory, stack -> stack.m_204117_(Tags.Items.DYES)).isPresent();
        return hasWater && hasDye;
    }

    public int getMaxDamage(ItemStack stack) {
        return super.getMaxDamage(stack);
    }

    public boolean m_41465_() {
        return true;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return super.canPerformAction(stack, toolAction);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag isAdvanced) {
        if (Screen.m_96638_()) {
            components.add((Component)new TextComponent("Repaints ").m_7220_((Component)new TextComponent("chimneys, vents or pumps").m_130940_(ChatFormatting.GREEN)).m_130946_(" if used in one hand while holding a ").m_7220_((Component)new TextComponent("sample block").m_130940_(ChatFormatting.DARK_PURPLE)).m_130946_(" in the other."));
            components.add((Component)new TextComponent(" "));
            components.add((Component)new TextComponent("Requires a ").m_7220_((Component)new TextComponent("bucket of water").m_130940_(ChatFormatting.DARK_AQUA)).m_130946_(" + ").m_7220_((Component)new TextComponent("some dyes").m_130940_(ChatFormatting.YELLOW)).m_130946_(" of any color in the inventory."));
            components.add((Component)new TextComponent(" "));
            components.add((Component)new TextComponent("Each successful repaint consumes one dye."));
        } else {
            components.add((Component)new TextComponent("Hold ").m_7220_((Component)new TextComponent("Shift").m_130940_(ChatFormatting.DARK_PURPLE)).m_130946_(" for more details"));
        }
        super.m_7373_(stack, level, components, isAdvanced);
    }
}

