/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.init;

import com.endertech.minecraft.forge.blocks.IEmitter;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.units.EmittersInit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adchimneys.compat.Delight;
import com.endertech.minecraft.mods.adchimneys.compat.Minecraft;
import com.endertech.minecraft.mods.adchimneys.smoke.Emitter;
import com.endertech.minecraft.mods.adchimneys.smoke.EmitterWithRandomColor;
import com.endertech.minecraft.mods.adchimneys.smoke.ISmokeEmitter;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;

public class Emitters
extends EmittersInit<Emitter, BuiltInEmitters> {
    public Emitters(AbstractForgeMod mod) {
        super(mod, BuiltInEmitters.class);
    }

    public Supplier<Emitter> createCustomUnitFrom(UnitConfig config, String name) {
        UnitId id = UnitId.from((Path)config.getConfigFile().toPath());
        return () -> new Emitter(config, (Emitter.Properties<?>)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().id(id)).smoke(2, 1.0f))));
    }

    public Supplier<Emitter> createDefaultUnitFrom(UnitConfig config, BuiltInEmitters e) {
        return () -> {
            Emitter.Properties props = (Emitter.Properties)((Object)((Object)e.props.get()));
            return props.factory.orElse(Emitter::new).apply(config, props);
        };
    }

    public Optional<Emitter> get(LevelReader reader, BlockPos pos) {
        BlockState state;
        Block block;
        if (reader.m_46805_(pos) && (block = (state = reader.m_8055_(pos)).m_60734_()) instanceof ISmokeEmitter) {
            return Optional.of(((ISmokeEmitter)block).getEmitter(reader, pos));
        }
        return super.get(reader, pos);
    }

    static enum BuiltInEmitters implements IForgeEnum
    {
        betterfurnacesreforged$iron_furnace(() -> ((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)),
        betterfurnacesreforged$gold_furnace(() -> ((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.2f)),
        betterfurnacesreforged$diamond_furnace(() -> ((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.4f)),
        betterfurnacesreforged$netherhot_furnace(() -> ((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(4, 2.0f)),
        betterfurnacesreforged$extreme_furnace(() -> ((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(8, 4.0f)),
        betterfurnacesreforged$extreme_forge(() -> ((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(8, 4.0f)),
        brickfurnace$brick_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)))).color(295063357)),
        brickfurnace$brick_blast_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.5f)))).color(290795557)),
        brickfurnace$brick_smoker(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 0.5f)))).color(295195714)),
        byg$boric_campfire(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().id("byg:boric_campfire:[lit=true, signal_fire=false]")).customFactory(Minecraft.Campfire::new)))).smoke(1, 0.1f)))).maxGapLength(2)),
        byg$boric_campfire_signal(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().id("byg:boric_campfire:[lit=true, signal_fire=true]")).customFactory(Minecraft.Campfire::new)))).smoke(2, 0.5f)))).color(-1154895597)))).maxGapLength(2)),
        byg$cryptic_campfire(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().id("byg:cryptic_campfire:[lit=true, signal_fire=false]")).customFactory(Minecraft.Campfire::new)))).smoke(1, 0.1f)))).maxGapLength(2)),
        byg$cryptic_campfire_signal(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().id("byg:cryptic_campfire:[lit=true, signal_fire=true]")).customFactory(Minecraft.Campfire::new)))).smoke(2, 0.5f)))).color(-1143203033)))).maxGapLength(2)),
        car$blast_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Emitter.Properties)Emitter.Properties.with().id("car:blastfurnace")).statePowered()).smoke(2, 1.5f)))).color(0x11B4B4B4)),
        ceramics$kiln(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)))).color(298084176)),
        charcoal_pit$bloomeryy(() -> ((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.5f)),
        charcoal_pit$blast_furnace(() -> ((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.5f)),
        charcoal_pit$distillery(() -> ((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)),
        charcoal_pit$steam_press(() -> ((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)),
        clayworks$kiln(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).notEmitWithoutChimney()))).smoke(2, 1.0f)),
        cookingforblockheads$oven(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().activeTag("BurnTime")).maxGapLength(2)))).smoke(2, 0.5f)),
        create$blaze_burner(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().metadata("[blaze=kindled]")).maxGapLength(2)))).smoke(2, 0.5f)),
        create$lit_blaze_burner(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().type(IEmitter.Type.BLOCK)).maxGapLength(2)))).smoke(1, 0.1f)),
        createdieselgenerators$diesel_engine(() -> ((Emitter.Properties)Emitter.Properties.with().id("createdieselgenerators:diesel_engine:[powered=true, silenced=false]")).smoke(1, 1.0f, 2.0f)),
        createdieselgenerators$diesel_engine_silenced(() -> ((Emitter.Properties)Emitter.Properties.with().id("createdieselgenerators:diesel_engine:[powered=true, silenced=true]")).smoke(1, 0.1f, 1.0f)),
        createdieselgenerators$large_diesel_engine(() -> ((Emitter.Properties)Emitter.Properties.with().id("createdieselgenerators:large_diesel_engine:[powered=true, silenced=false]")).smoke(2, 1.0f, 2.0f)),
        createdieselgenerators$large_diesel_engine_silenced(() -> ((Emitter.Properties)Emitter.Properties.with().id("createdieselgenerators:large_diesel_engine:[powered=true, silenced=true]")).smoke(2, 0.1f, 1.0f)),
        crossroads$firebox(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f)))).color(287515431)),
        environmental$kiln(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)))).color(291981363)),
        farmersdelight$stove(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).customFactory(Delight.Stove::new)))).smoke(2, 1.0f)))).maxGapLength(2)),
        furnacemk2$furnacemk2(() -> ((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)),
        jumbofurnace$jumbo_furnace(() -> (Emitter.Properties)((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().metadata("[lit=true, x=1, y=1, z=0]")).smoke(3, 1.5f)))).color(0x11808080).relatedBlocks(new String[]{"jumbofurnace:jumbo_furnace:*"})),
        handcrafted$oven(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 0.5f)))).maxGapLength(2)),
        ic2$fuel_boiler(() -> (Emitter.Properties)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(3, 1.0f).relatedBlocks(new String[]{"ic2:fuel_boiler_structure:*"})),
        ic2$generator(() -> ((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f)),
        ic2$iron_furnace(() -> ((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f)),
        ic2$liquid_generator(() -> ((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f)),
        ic2$slag_generator(() -> ((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f)),
        ic2$stone_canner(() -> ((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f)),
        ic2$stone_macerator(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f)))).notEmitWithoutChimney()),
        ic2$wood_gassifier(() -> ((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f)),
        immersiveengineering$alloy_smelter(() -> (Emitter.Properties)((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().metadata("[active=true, multiblockslave=false]")).smoke(3, 1.2f)))).color(293159744).relatedBlocks(new String[]{"immersiveengineering:alloy_smelter:[multiblockslave=true]"})),
        immersiveengineering$coke_oven(() -> (Emitter.Properties)((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().metadata("[active=true, multiblockslave=false]")).smoke(3, 1.5f)))).color(0x11333333).relatedBlocks(new String[]{"immersiveengineering:coke_oven:[multiblockslave=true]"})),
        immersiveengineering$blast_furnace(() -> (Emitter.Properties)((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().metadata("[active=true, multiblockslave=false]")).smoke(3, 1.5f)))).color(291450657).relatedBlocks(new String[]{"immersiveengineering:blast_furnace:[multiblockslave=true]"})),
        immersiveengineering$advanced_blast_furnace(() -> (Emitter.Properties)((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().metadata("[active=true, multiblockslave=false]")).smoke(3, 1.5f)))).color(291450657)))).notEmitAside()))).notEmitWithoutChimney().relatedBlocks(new String[]{"immersiveengineering:advanced_blast_furnace:[multiblockslave=true]"})),
        immersiveengineering$diesel_generator(() -> (Emitter.Properties)((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Emitter.Properties)Emitter.Properties.with().metadata("[multiblockslave=false]")).activeTag("active")).smoke(2, 1.0f)))).color(0x11353535)))).notEmitWithoutChimney().relatedBlocks(new String[]{"immersiveengineering:diesel_generator:[multiblockslave=true]"})),
        industrialforegoing$biofuel_generator(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().activeTag("progressBar/Tick")).smoke(2, 1.0f)))).color(293816094)),
        industrialforegoing$pitiful_generator(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().activeTag("progressBar/Tick")).smoke(2, 1.0f)))).color(291257388)),
        ironfurnaces$iron_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)))).color(0x11727272)),
        ironfurnaces$silver_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.5f)))).color(0x11818D8D)),
        ironfurnaces$copper_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.5f)))).color(300061756)),
        ironfurnaces$gold_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.5f)))).color(301382435)),
        ironfurnaces$diamond_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(3, 2.0f)))).color(289201634)),
        ironfurnaces$emerald_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(3, 2.0f)))).color(287359535)),
        ironfurnaces$obsidian_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(3, 2.0f)))).color(287512370)),
        ironfurnaces$crystal_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(3, 2.5f)))).color(287553270)),
        ironfurnaces$netherite_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(4, 4.0f)))).color(287579679)),
        ironfurnaces$million_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)))).color(0x11FFFFFF)))).customFactory(EmitterWithRandomColor::new)),
        mekanism$fuelwood_heater(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f)))).color(293232211)),
        mekanismgenerators$gas_burning_generator(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f)))).color(289291585)),
        mekanismgenerators$bio_generator(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 0.5f)))).color(289291585)),
        mekanismgenerators$heat_generator(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.5f)))).color(289291585)),
        minecraft$campfire(() -> Emitter.Properties.campfire("minecraft:campfire")),
        minecraft$campfire_signal(() -> Emitter.Properties.signal_campfire("minecraft:campfire", -1140890112)),
        minecraft$soul_campfire(() -> Emitter.Properties.campfire("minecraft:soul_campfire")),
        minecraft$soul_campfire_signal(() -> Emitter.Properties.signal_campfire("minecraft:soul_campfire", -1149439243)),
        minecraft$furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)))).color(0x11808080)),
        minecraft$blast_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.5f)))).color(289291585)),
        minecraft$smoker(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 0.5f)))).color(291851819)),
        mysticalagriculture$basic_reprocessor(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().activeTag("FuelLeft")).smoke(2, 1.0f)))).color(297515705)),
        mysticalagriculture$inferium_reprocessor(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().activeTag("FuelLeft")).smoke(2, 1.0f)))).color(294825216)),
        mysticalagriculture$inferium_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)))).color(294825216)),
        mysticalagriculture$prudentium_reprocessor(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().activeTag("FuelLeft")).smoke(2, 1.2f)))).color(285258540)),
        mysticalagriculture$prudentium_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.2f)))).color(285258540)),
        mysticalagriculture$tertium_reprocessor(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().activeTag("FuelLeft")).smoke(2, 1.4f)))).color(299520512)),
        mysticalagriculture$tertium_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.4f)))).color(299520512)),
        mysticalagriculture$imperium_reprocessor(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().activeTag("FuelLeft")).smoke(2, 1.6f)))).color(285248752)),
        mysticalagriculture$imperium_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.6f)))).color(285248752)),
        mysticalagriculture$supremium_reprocessor(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().activeTag("FuelLeft")).smoke(2, 1.8f)))).color(299237376)),
        mysticalagriculture$supremium_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.8f)))).color(299237376)),
        nethersdelight$blackstone_stove(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).customFactory(Delight.Stove::new)))).smoke(2, 1.0f)))).maxGapLength(2)),
        nethersdelight$blackstone_furnace(() -> ((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)),
        nethersdelight$blackstone_blast_furnace(() -> ((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.5f)),
        nethersdelight$nether_brick_smoker(() -> ((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 0.5f)),
        pneumaticcraft$air_compressor(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.with().activeProperty("on")))).smoke(2, 1.0f)))).color(0x11808080)),
        pneumaticcraft$advanced_air_compressor(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.with().activeProperty("on")))).smoke(2, 1.0f)))).color(0x11484848)),
        pneumaticcraft$liquid_compressor(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.with().activeProperty("on")))).smoke(2, 1.0f)))).color(0x11808080)),
        pneumaticcraft$advanced_liquid_compressor(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.with().activeProperty("on")))).smoke(2, 1.0f)))).color(0x11484848)),
        quark$blackstone_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)))).color(289093702)),
        quark$deepslate_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)))).color(0x11686868)),
        rftoolspower$blazing_generator(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().metadata("[working=true]")).smoke(2, 1.0f)))).color(0x11787878)),
        rftoolspower$coal_generator(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Emitter.Properties)Emitter.Properties.with().id("rftoolspower:coalgenerator")).stateLit()).smoke(2, 1.0f)))).color(0x11787878)),
        silents_mechanisms$coal_generator(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(3, 1.5f)))).color(0x11707070)),
        silents_mechanisms$lava_generator(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 0.5f)))).color(585140798)),
        silents_mechanisms$diesel_generator(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.5f)))).color(299558467)),
        simplekiln$kiln(() -> ((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)),
        steampowered$cast_iron_burner(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)))).color(0x11444444)),
        steampowered$bronze_burner(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)))).color(298297460)),
        steampowered$steel_burner(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)))).color(0x11898989)),
        tconstruct$seared_melter(() -> (Emitter.Properties)((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Emitter.Properties)Emitter.Properties.with().stateActive()).activeTag("fuel")).notEmitWithoutChimney()))).smoke(2, 1.0f)))).color(290079297).relatedBlocks(new String[]{"#tconstruct:fuel_tanks"})),
        tconstruct$foundry_controller(() -> (Emitter.Properties)((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Emitter.Properties)Emitter.Properties.with().stateActive()).activeTag("fuel")).notEmitWithoutChimney()))).smoke(2, 1.0f)))).color(289024806).relatedBlocks(new String[]{"#tconstruct:foundry/wall", "#tconstruct:foundry/floor"})),
        tconstruct$smeltery_controller(() -> (Emitter.Properties)((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Emitter.Properties)Emitter.Properties.with().stateActive()).activeTag("fuel")).notEmitWithoutChimney()))).smoke(2, 1.0f)))).color(290079297).relatedBlocks(new String[]{"#tconstruct:smeltery/wall", "#tconstruct:smeltery/floor"})),
        thermal$dynamo_stirling(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f)))).color(291067735)),
        thermal$dynamo_compression(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f)))).color(297588455)),
        thermal$dynamo_magmatic(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f)))).color(295742885)),
        thermal$machine_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f)))).color(296993474)),
        thermal$machine_smelter(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f)))).color(296993474)),
        tintedcampfires$black_campfire(() -> Emitter.Properties.campfire("tintedcampfires:black_campfire")),
        tintedcampfires$black_campfire_signal(() -> Emitter.Properties.signal_campfire("tintedcampfires:black_campfire", -1155064809)),
        tintedcampfires$blue_campfire(() -> Emitter.Properties.campfire("tintedcampfires:blue_campfire")),
        tintedcampfires$blue_campfire_signal(() -> Emitter.Properties.signal_campfire("tintedcampfires:blue_campfire", -1151513460)),
        tintedcampfires$brown_campfire(() -> Emitter.Properties.campfire("tintedcampfires:brown_campfire")),
        tintedcampfires$brown_campfire_signal(() -> Emitter.Properties.signal_campfire("tintedcampfires:brown_campfire", -1145479386)),
        tintedcampfires$green_campfire(() -> Emitter.Properties.campfire("tintedcampfires:green_campfire")),
        tintedcampfires$green_campfire_signal(() -> Emitter.Properties.signal_campfire("tintedcampfires:green_campfire", -1150852085)),
        tintedcampfires$red_campfire(() -> Emitter.Properties.campfire("tintedcampfires:red_campfire")),
        tintedcampfires$red_campfire_signal(() -> Emitter.Properties.signal_campfire("tintedcampfires:red_campfire", -1142932446)),
        tintedcampfires$white_campfire(() -> Emitter.Properties.campfire("tintedcampfires:white_campfire")),
        tintedcampfires$white_campfire_signal(() -> Emitter.Properties.signal_campfire("tintedcampfires:white_campfire", -1141181727)),
        tintedcampfires$yellow_campfire(() -> Emitter.Properties.campfire("tintedcampfires:yellow_campfire")),
        tintedcampfires$yellow_campfire_signal(() -> Emitter.Properties.signal_campfire("tintedcampfires:yellow_campfire", -1141183981)),
        tintedcampfires$light_blue_campfire(() -> Emitter.Properties.campfire("tintedcampfires:light_blue_campfire")),
        tintedcampfires$light_blue_campfire_signal(() -> Emitter.Properties.signal_campfire("tintedcampfires:light_blue_campfire", -1152992337)),
        tintedcampfires$light_gray_campfire(() -> Emitter.Properties.campfire("tintedcampfires:light_gray_campfire")),
        tintedcampfires$light_gray_campfire_signal(() -> Emitter.Properties.signal_campfire("tintedcampfires:light_gray_campfire", -1142501731)),
        tintedcampfires$lime_campfire(() -> Emitter.Properties.campfire("tintedcampfires:lime_campfire")),
        tintedcampfires$lime_campfire_signal(() -> Emitter.Properties.signal_campfire("tintedcampfires:lime_campfire", -1145190114)),
        tintedcampfires$magenta_campfire(() -> Emitter.Properties.campfire("tintedcampfires:magenta_campfire")),
        tintedcampfires$magenta_campfire_signal(() -> Emitter.Properties.signal_campfire("tintedcampfires:magenta_campfire", -1142335323)),
        tintedcampfires$orange_campfire(() -> Emitter.Properties.campfire("tintedcampfires:orange_campfire")),
        tintedcampfires$orange_campfire_signal(() -> Emitter.Properties.signal_campfire("tintedcampfires:orange_campfire", -1142723066)),
        tintedcampfires$pink_campfire(() -> Emitter.Properties.campfire("tintedcampfires:pink_campfire")),
        tintedcampfires$pink_campfire_signal(() -> Emitter.Properties.signal_campfire("tintedcampfires:pink_campfire", -1141132106)),
        tintedcampfires$cyan_campfire(() -> Emitter.Properties.campfire("tintedcampfires:cyan_campfire")),
        tintedcampfires$cyan_campfire_signal(() -> Emitter.Properties.signal_campfire("tintedcampfires:cyan_campfire", -1154504575)),
        tintedcampfires$gray_campfire(() -> Emitter.Properties.campfire("tintedcampfires:gray_campfire")),
        tintedcampfires$gray_campfire_signal(() -> Emitter.Properties.signal_campfire("tintedcampfires:gray_campfire", -1147962791)),
        tintedcampfires$purple_campfire(() -> Emitter.Properties.campfire("tintedcampfires:purple_campfire")),
        tintedcampfires$purple_campfire_signal(() -> Emitter.Properties.signal_campfire("tintedcampfires:purple_campfire", -1145425005)),
        twilightdelight$maze_stove(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).customFactory(Delight.Stove::new)))).smoke(2, 1.0f)))).maxGapLength(2));

        final Lazy<Emitter.Properties<?>> props = Lazy.of(() -> (Emitter.Properties)((Emitter.Properties)((Object)((Object)props.get()))).emptyToEnumId(this, true));

        private BuiltInEmitters(Supplier<Emitter.Properties<?>> props) {
        }
    }
}

