/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.blocks;

import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.blocks.IWaterLoggable;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.tiles.ChameleonBlockTile;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.items.Paintbrush;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;

public abstract class Container
extends ForgeBlock
implements ISmokeContainer,
IWaterLoggable {
    public Container(Properties<?> props) {
        super((AbstractForgeMod)AdChimneys.getInstance(), null, props);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (Paintbrush.in(player, hand) && (blockEntity = level.m_7702_(pos)) instanceof ChameleonBlockTile) {
            ChameleonBlockTile tile = (ChameleonBlockTile)blockEntity;
            InteractionHand otherHand = ForgeEntity.otherHand((InteractionHand)hand);
            BlockState sampleBlock = Block.m_49814_((Item)player.m_21120_(otherHand).m_41720_()).m_49966_();
            if (tile.getTargetBlock() != sampleBlock && this.isProperPaintSample(sampleBlock, state, level, pos) && Paintbrush.hasAllRequiredMaterials(player)) {
                if (!level.m_5776_()) {
                    tile.setTargetBlock(sampleBlock);
                    player.m_21120_(hand).m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                    if (((Boolean)Paintbrush.requiresDye.get()).booleanValue() && !player.m_150110_().f_35937_) {
                        Inventory inventory = player.m_150109_();
                        ForgeItem.indexIn((Inventory)inventory, stack -> stack.m_204117_(Tags.Items.DYES)).ifPresent(i -> inventory.m_8020_(i.intValue()).m_41774_(1));
                    }
                }
                level.m_5594_(player, pos, SoundEvents.f_144228_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    protected boolean isProperPaintSample(BlockState sampleBlock, BlockState targetBlock, Level level, BlockPos pos) {
        for (Direction direction : GameWorld.Directions.of().all().toList()) {
            if (!Block.m_49918_((VoxelShape)sampleBlock.m_60768_((BlockGetter)level, pos), (Direction)direction)) continue;
            return sampleBlock.m_60767_().m_76337_() || targetBlock.m_60767_() == Material.f_76275_;
        }
        return false;
    }

    public FluidState m_5888_(BlockState state) {
        return IWaterLoggable.getFluidState((BlockState)state, (boolean)false);
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return Shapes.m_83144_();
    }

    public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        return true;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return IWaterLoggable.updateFluidPostPlacement((LevelAccessor)worldIn, (BlockPos)currentPos, (BlockState)stateIn);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return IWaterLoggable.getStateForPlacement((BlockPlaceContext)context, (BlockState)this.m_49966_());
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public boolean isOpaqueMaterial(BlockState state) {
        return state.m_60767_().m_76337_() && state.m_60767_() != Material.f_76275_;
    }

    public ColorARGB getColor() {
        return ColorARGB.DEFAULT;
    }

    public static class Tile
    extends ChameleonBlockTile {
        public Tile(BlockPos pos, BlockState state) {
            super(AdChimneys.getInstance().tiles.container.get(), pos, state);
        }
    }

    public static class Properties<T extends Properties<T>>
    extends ForgeBlock.Properties<T> {
        protected Properties(Class<T> selfClass, String name, Material material) {
            super(selfClass, name, material);
            this.blockProps.m_60977_();
        }

        public static Properties<?> of(String name, Material material) {
            return new Properties<Properties>(Properties.class, name, material);
        }

        public static Properties<?> ofStone(String name) {
            Properties<?> props = Properties.of(name, Material.f_76278_);
            props.blockProps.m_60913_(2.0f, 6.0f).m_60999_();
            return props;
        }

        public static Properties<?> ofMetal(String name) {
            Properties<?> props = Properties.of(name, Material.f_76279_);
            props.blockProps.m_60913_(5.0f, 6.0f).m_60999_().m_60918_(SoundType.f_56743_);
            return props;
        }

        public static Properties<?> ofGlass(String name) {
            Properties<?> props = Properties.of(name, Material.f_76275_);
            props.blockProps.m_60978_(0.3f).m_60918_(SoundType.f_56744_).m_60955_().m_60922_((s, w, p, a) -> false).m_60924_((s, w, p) -> false).m_60960_((s, w, p) -> false).m_60971_((s, w, p) -> false);
            return props;
        }
    }
}

