/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curiouslights.dynamiclights;

import atomicstryker.dynamiclights.server.DynamicLights;
import atomicstryker.dynamiclights.server.GsonConfig;
import atomicstryker.dynamiclights.server.IDynamicLightSource;
import atomicstryker.dynamiclights.server.ItemConfigHelper;
import atomicstryker.dynamiclights.server.ItemLightLevels;
import atomicstryker.dynamiclights.server.modules.LightConfig;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;

public class CuriosLightSource {
    private static final Logger LOGGER = LogManager.getLogger();
    private static ItemConfigHelper itemsMap;
    private static ItemConfigHelper notWaterProofItems;
    private final Map<Player, CuriosLightSourceContainer> playerLightsMap = new HashMap<Player, CuriosLightSourceContainer>();

    @SubscribeEvent
    public void serverStartEvent(ServerAboutToStartEvent evt) {
        LightConfig defaultConfig = new LightConfig();
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack((ItemStack)new ItemStack((ItemLike)Blocks.f_50081_), (int)14));
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack((ItemStack)new ItemStack((ItemLike)Blocks.f_50141_), (int)15));
        defaultConfig.getNotWaterProofList().add(ItemConfigHelper.fromItemStack((ItemStack)new ItemStack((ItemLike)Blocks.f_50081_), (int)0));
        MinecraftServer server = evt.getServer();
        File configFile = new File(server.m_129971_(""), File.separatorChar + "config" + File.separatorChar + "dynamiclights_selflight.cfg");
        try {
            LightConfig config = (LightConfig)GsonConfig.loadConfigWithDefault(LightConfig.class, (File)configFile, (Object)defaultConfig);
            if (config == null) {
                throw new UnsupportedOperationException("CuriosLightSource failed parsing config file somehow...");
            }
            itemsMap = new ItemConfigHelper(config.getItemsList(), LOGGER);
            notWaterProofItems = new ItemConfigHelper(config.getNotWaterProofList(), LOGGER);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent evt) {
        if (evt.side != LogicalSide.SERVER) {
            return;
        }
        Player player = evt.player;
        if (player.m_6084_()) {
            CuriosLightSourceContainer curiosLightSourceContainer = this.playerLightsMap.get(player);
            if (curiosLightSourceContainer == null) {
                LOGGER.trace("built new CuriosLightSourceContainer for player {}", (Object)player);
                curiosLightSourceContainer = new CuriosLightSourceContainer(player);
                this.playerLightsMap.put(player, curiosLightSourceContainer);
            }
            int prevLight = curiosLightSourceContainer.lightLevel;
            boolean isUnderwater = this.checkPlayerWater(player);
            curiosLightSourceContainer.lightLevel = 0;
            CuriosLightSourceContainer finalCuriosLightSourceContainer = curiosLightSourceContainer;
            CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player).ifPresent(curios -> {
                for (int i = 0; i < curios.getSlots(); ++i) {
                    ItemStack stack = curios.getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    finalCuriosLightSourceContainer.lightLevel = Math.max(finalCuriosLightSourceContainer.lightLevel, this.getLightFromItemStack(stack, isUnderwater));
                }
            });
            if (prevLight != 0 && curiosLightSourceContainer.lightLevel != prevLight) {
                curiosLightSourceContainer.lightLevel = 0;
            }
            if (!curiosLightSourceContainer.enabled && curiosLightSourceContainer.lightLevel > 0) {
                this.enableLight(curiosLightSourceContainer);
            } else if (curiosLightSourceContainer.enabled && curiosLightSourceContainer.lightLevel < 1) {
                this.disableLight(curiosLightSourceContainer);
            }
        } else {
            CuriosLightSourceContainer curiosLightSourceContainer = this.playerLightsMap.get(evt.player);
            if (curiosLightSourceContainer != null) {
                this.disableLight(curiosLightSourceContainer);
                this.playerLightsMap.remove(curiosLightSourceContainer.player);
            }
        }
    }

    private boolean checkPlayerWater(Player player) {
        return player.m_204029_(FluidTags.f_13131_);
    }

    private int getLightFromItemStack(ItemStack stack, boolean isUnderwater) {
        if (isUnderwater && (notWaterProofItems.getLightLevel(stack) > 0 || stack.m_204131_().anyMatch(rl -> rl.f_203868_().equals((Object)DynamicLights.NOT_WATERPROOF_TAG)))) {
            return 0;
        }
        int level = ItemLightLevels.getLightFromItemStack((ItemStack)stack, (String)"self");
        if (level > 0 && level <= 15) {
            return level;
        }
        return itemsMap.getLightLevel(stack);
    }

    private void enableLight(CuriosLightSourceContainer container) {
        DynamicLights.addLightSource((IDynamicLightSource)container);
        container.enabled = true;
    }

    private void disableLight(CuriosLightSourceContainer container) {
        DynamicLights.removeLightSource((IDynamicLightSource)container);
        container.enabled = false;
    }

    public static class CuriosLightSourceContainer
    implements IDynamicLightSource {
        public int lightLevel;
        public boolean enabled;
        public Player player;

        CuriosLightSourceContainer(Player player) {
            this.player = player;
            this.lightLevel = 0;
            this.enabled = false;
        }

        public Entity getAttachmentEntity() {
            return this.player;
        }

        public int getLightLevel() {
            return this.lightLevel;
        }
    }
}

