/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curiouslights;

import java.util.Objects;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.theillusivec4.curiouslights.arsnouveau.ArsNouveauModule;
import top.theillusivec4.curiouslights.dynamiclights.DynamicLightsModule;
import top.theillusivec4.curiouslights.dynamiclightsreforged.DLReforgedModule;

@Mod(value="curiouslights")
public class CuriousLights {
    public static final String MOD_ID = "curiouslights";
    public static final Logger LOG = LoggerFactory.getLogger((String)"curiouslights");
    private static boolean isDynamicLightsLoaded = false;
    private static boolean isDLReforgedLoaded = false;
    private static boolean isArsNouveauLoaded = false;

    public CuriousLights() {
        ModList modList = ModList.get();
        isDynamicLightsLoaded = modList.isLoaded("dynamiclights");
        isDLReforgedLoaded = modList.isLoaded("dynamiclightsreforged");
        isArsNouveauLoaded = modList.isLoaded("ars_nouveau");
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        ModLoadingContext context = ModLoadingContext.get();
        context.registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> this.getRemoteVersion(context), (incoming, isNetwork) -> this.acceptsServer(context, (String)incoming)));
    }

    private void setup(FMLCommonSetupEvent evt) {
        if (isDynamicLightsLoaded) {
            DynamicLightsModule.setup();
        }
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        if (isDLReforgedLoaded) {
            DLReforgedModule.setup();
        }
        if (isArsNouveauLoaded) {
            ArsNouveauModule.setup();
        }
    }

    private String getRemoteVersion(ModLoadingContext context) {
        if (isDynamicLightsLoaded) {
            return context.getActiveContainer().getModInfo().getVersion().toString();
        }
        return "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31";
    }

    private boolean acceptsServer(ModLoadingContext context, String incoming) {
        if (isDynamicLightsLoaded) {
            return Objects.equals(incoming, context.getActiveContainer().getModInfo().getVersion().toString());
        }
        return true;
    }
}

