/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterfortresses.util;

import com.google.common.collect.ImmutableList;
import com.yungnickyoung.minecraft.betterfortresses.mixin.accessor.StructureFeatureManagerAccessor;
import com.yungnickyoung.minecraft.betterfortresses.mixin.accessor.WorldGenRegionAccessor;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.FeatureAccess;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class MixinUtil {
    public static StructureStart getStructureAt(StructureFeatureManager structureManager, BlockPos pos, ConfiguredStructureFeature<?, ?> structure) {
        for (StructureStart structureStart : MixinUtil.startsForStructure(structureManager, SectionPos.m_123199_((BlockPos)pos), structure)) {
            if (!structureStart.m_73601_().m_71051_((Vec3i)pos)) continue;
            return structureStart;
        }
        return StructureStart.f_73561_;
    }

    private static List<StructureStart> startsForStructure(StructureFeatureManager structureManager, SectionPos sectionPos, ConfiguredStructureFeature<?, ?> structure) {
        LongSet longset = ((StructureFeatureManagerAccessor)structureManager).getLevel().m_46819_(sectionPos.m_123170_(), sectionPos.m_123222_(), ChunkStatus.f_62316_).m_207420_(structure);
        ImmutableList.Builder builder = ImmutableList.builder();
        MixinUtil.fillStartsForStructure(structureManager, structure, longset, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    private static void fillStartsForStructure(StructureFeatureManager structureManager, ConfiguredStructureFeature<?, ?> structure, LongSet longSet, Consumer<StructureStart> consumer) {
        LongIterator longIterator = longSet.iterator();
        while (longIterator.hasNext()) {
            StructureStart structurestart;
            long i = (Long)longIterator.next();
            SectionPos sectionpos = SectionPos.m_123196_((ChunkPos)new ChunkPos(i), (int)((StructureFeatureManagerAccessor)structureManager).getLevel().m_151560_());
            Optional<ChunkAccess> chunkAccess = MixinUtil.getChunk((WorldGenRegion)((StructureFeatureManagerAccessor)structureManager).getLevel(), sectionpos.m_123170_(), sectionpos.m_123222_());
            if (!chunkAccess.isPresent() || (structurestart = structureManager.m_207802_(sectionpos, structure, (FeatureAccess)chunkAccess.get())) == null || !structurestart.m_73603_()) continue;
            consumer.accept(structurestart);
        }
    }

    private static Optional<ChunkAccess> getChunk(WorldGenRegion worldGenRegion, int chunkX, int chunkZ) {
        WorldGenRegionAccessor accessor = (WorldGenRegionAccessor)worldGenRegion;
        if (worldGenRegion.m_7232_(chunkX, chunkZ)) {
            int i = chunkX - accessor.getFirstPos().f_45578_;
            int j = chunkZ - accessor.getFirstPos().f_45579_;
            ChunkAccess chunkAccess = accessor.getCache().get(i + j * accessor.getSize());
            if (chunkAccess.m_6415_().m_62427_(ChunkStatus.f_62315_)) {
                return Optional.of(chunkAccess);
            }
        }
        return Optional.empty();
    }
}

