/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.mixin.entity.inactive_navigations;

import com.abdelaziz.canary.common.entity.NavigatingEntity;
import com.abdelaziz.canary.common.world.ServerWorldExtended;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public abstract class MobMixin
extends Entity
implements NavigatingEntity {
    private PathNavigation registeredNavigation;

    public MobMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Shadow
    public abstract PathNavigation m_21573_();

    @Override
    public boolean isRegisteredToWorld() {
        return this.registeredNavigation != null;
    }

    @Override
    public void setRegisteredToWorld(PathNavigation navigation) {
        this.registeredNavigation = navigation;
    }

    @Override
    public PathNavigation getRegisteredNavigation() {
        return this.registeredNavigation;
    }

    @Inject(method={"startRiding(Lnet/minecraft/world/entity/Entity;Z)Z"}, at={@At(value="RETURN")})
    private void onNavigationReplacement(Entity entity, boolean force, CallbackInfoReturnable<Boolean> cir) {
        this.updateNavigationRegistration();
    }

    @Intrinsic
    public void m_8127_() {
        super.m_8127_();
    }

    @Inject(method={"stopRiding()V"}, at={@At(value="RETURN")})
    private void updateOnStopRiding(CallbackInfo ci) {
        this.updateNavigationRegistration();
    }

    @Override
    public void updateNavigationRegistration() {
        PathNavigation navigation;
        if (this.isRegisteredToWorld() && this.registeredNavigation != (navigation = this.m_21573_())) {
            ((ServerWorldExtended)this.f_19853_).setNavigationInactive((Mob)this);
            this.registeredNavigation = navigation;
            if (navigation.m_26570_() != null) {
                ((ServerWorldExtended)this.f_19853_).setNavigationActive((Mob)this);
            }
        }
    }
}

