/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.fastener;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import me.paulf.fairylights.FairyLights;
import me.paulf.fairylights.server.capability.CapabilityHandler;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.ConnectionType;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.fastener.FastenerType;
import me.paulf.fairylights.server.fastener.accessor.FastenerAccessor;
import me.paulf.fairylights.util.AABBBuilder;
import me.paulf.fairylights.util.Curve;
import me.paulf.fairylights.util.RegistryObjects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public abstract class AbstractFastener<F extends FastenerAccessor>
implements Fastener<F> {
    private final Map<UUID, Connection> outgoing = new HashMap<UUID, Connection>();
    private final Map<UUID, Incoming> incoming = new HashMap<UUID, Incoming>();
    protected AABB bounds = BlockEntity.INFINITE_EXTENT_AABB;
    @Nullable
    private Level world;
    private boolean dirty;
    private final LazyOptional<Fastener<?>> lazyOptional = LazyOptional.of(() -> this);

    @Override
    public Optional<Connection> get(UUID id) {
        return Optional.ofNullable(this.outgoing.get(id));
    }

    @Override
    public List<Connection> getOwnConnections() {
        return ImmutableList.copyOf(this.outgoing.values());
    }

    @Override
    public List<Connection> getAllConnections() {
        ImmutableList.Builder list = new ImmutableList.Builder();
        list.addAll(this.outgoing.values());
        if (this.world != null) {
            this.incoming.values().forEach(i -> i.get(this.world).ifPresent(arg_0 -> ((ImmutableList.Builder)list).add(arg_0)));
        }
        return list.build();
    }

    @Override
    public AABB getBounds() {
        return this.bounds;
    }

    @Override
    public abstract BlockPos getPos();

    @Override
    public void setWorld(Level world) {
        this.world = world;
        this.outgoing.values().forEach(c -> c.setWorld(world));
    }

    @Override
    @Nullable
    public Level getWorld() {
        return this.world;
    }

    @Override
    public boolean update() {
        Iterator<Connection> it = this.outgoing.values().iterator();
        Vec3 fromOffset = this.getConnectionPoint();
        boolean dirty = this.dirty;
        this.dirty = false;
        while (it.hasNext()) {
            Connection connection = it.next();
            if (connection.update(fromOffset)) {
                dirty = true;
            }
            if (!connection.isRemoved()) continue;
            dirty = true;
            it.remove();
            this.incoming.remove(connection.getUUID());
            if (this.world == null) continue;
            this.drop(this.world, this.getPos(), connection);
        }
        if (this.world != null) {
            this.incoming.values().removeIf(incoming -> incoming.gone(this.world));
        }
        if (dirty) {
            this.calculateBoundingBox();
        }
        return dirty;
    }

    @Override
    public void setDirty() {
        this.dirty = true;
    }

    protected void calculateBoundingBox() {
        if (this.outgoing.isEmpty()) {
            this.bounds = new AABB(this.getPos());
            return;
        }
        AABBBuilder builder = new AABBBuilder();
        for (Connection connection : this.outgoing.values()) {
            Curve catenary = connection.getCatenary();
            if (catenary == null) continue;
            Curve.SegmentIterator it = catenary.iterator();
            while (it.next()) {
                builder.include(it.getX(0.0f), it.getY(0.0f), it.getZ(0.0f));
                if (it.hasNext()) continue;
                builder.include(it.getX(1.0f), it.getY(1.0f), it.getZ(1.0f));
            }
        }
        this.bounds = builder.add(this.getConnectionPoint()).build();
    }

    @Override
    public void dropItems(Level world, BlockPos pos) {
        for (Connection connection : this.getAllConnections()) {
            this.drop(world, pos, connection);
        }
    }

    private void drop(Level world, BlockPos pos, Connection connection) {
        if (!connection.shouldDrop()) {
            return;
        }
        float offsetX = world.f_46441_.nextFloat() * 0.8f + 0.1f;
        float offsetY = world.f_46441_.nextFloat() * 0.8f + 0.1f;
        float offsetZ = world.f_46441_.nextFloat() * 0.8f + 0.1f;
        ItemStack stack = connection.getItemStack();
        ItemEntity entityItem = new ItemEntity(world, (double)((float)pos.m_123341_() + offsetX), (double)((float)pos.m_123342_() + offsetY), (double)((float)pos.m_123343_() + offsetZ), stack);
        float scale = 0.05f;
        entityItem.m_20334_(world.f_46441_.nextGaussian() * (double)0.05f, world.f_46441_.nextGaussian() * (double)0.05f + (double)0.2f, world.f_46441_.nextGaussian() * (double)0.05f);
        world.m_7967_((Entity)entityItem);
        connection.noDrop();
    }

    @Override
    public void remove() {
        this.outgoing.values().forEach(Connection::remove);
    }

    @Override
    public boolean hasNoConnections() {
        return this.outgoing.isEmpty() && this.incoming.isEmpty();
    }

    @Override
    public boolean hasConnectionWith(Fastener<?> fastener) {
        return this.getConnectionTo((FastenerAccessor)fastener.createAccessor()) != null;
    }

    @Override
    @Nullable
    public Connection getConnectionTo(FastenerAccessor destination) {
        for (Connection connection : this.outgoing.values()) {
            if (!connection.isDestination(destination)) continue;
            return connection;
        }
        return null;
    }

    @Override
    public boolean removeConnection(UUID uuid) {
        Connection connection = this.outgoing.remove(uuid);
        if (connection != null) {
            connection.remove();
            this.setDirty();
            return true;
        }
        if (this.incoming.remove(uuid) != null) {
            this.setDirty();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeConnection(Connection connection) {
        return this.removeConnection(connection.getUUID());
    }

    @Override
    public boolean reconnect(Level world, Connection connection, Fastener<?> newDestination) {
        if (this.equals(newDestination) || newDestination.hasConnectionWith(this)) {
            return false;
        }
        UUID uuid = connection.getUUID();
        if (connection.getDestination().get(world, false).filter(t -> {
            t.removeConnection(uuid);
            return true;
        }).isPresent()) {
            connection.setDestination(newDestination);
            connection.setDrop();
            newDestination.createIncomingConnection(this.world, uuid, this, connection.getType());
            this.setDirty();
            return true;
        }
        return false;
    }

    @Override
    public Connection connect(Level world, Fastener<?> destination, ConnectionType<?> type, CompoundTag compound, boolean drop) {
        UUID uuid = Mth.m_14002_();
        Connection connection = this.createOutgoingConnection(world, uuid, destination, type, compound, drop);
        destination.createIncomingConnection(world, uuid, this, type);
        return connection;
    }

    @Override
    public Connection createOutgoingConnection(Level world, UUID uuid, Fastener<?> destination, ConnectionType<?> type, CompoundTag compound, boolean drop) {
        Object c = type.create(world, this, uuid);
        ((Connection)c).deserialize(destination, compound, drop);
        this.outgoing.put(uuid, (Connection)c);
        this.setDirty();
        return c;
    }

    @Override
    public void createIncomingConnection(Level world, UUID uuid, Fastener<?> destination, ConnectionType<?> type) {
        this.incoming.put(uuid, new Incoming((FastenerAccessor)destination.createAccessor(), uuid));
        this.setDirty();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        ListTag outgoing = new ListTag();
        for (Map.Entry<UUID, Connection> connectionEntry : this.outgoing.entrySet()) {
            UUID uuid = connectionEntry.getKey();
            Connection connection = connectionEntry.getValue();
            CompoundTag connectionCompound = new CompoundTag();
            connectionCompound.m_128365_("connection", (Tag)connection.serialize());
            connectionCompound.m_128359_("type", RegistryObjects.getName(connection.getType()).toString());
            connectionCompound.m_128362_("uuid", uuid);
            outgoing.add((Object)connectionCompound);
        }
        compound.m_128365_("outgoing", (Tag)outgoing);
        ListTag incoming = new ListTag();
        for (Map.Entry<UUID, Incoming> e : this.incoming.entrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("uuid", e.getKey());
            tag.m_128365_("fastener", (Tag)FastenerType.serialize(e.getValue().fastener));
            incoming.add((Object)tag);
        }
        compound.m_128365_("incoming", (Tag)incoming);
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        ListTag listConnections = compound.m_128437_("outgoing", 10);
        ArrayList<UUID> nbtUUIDs = new ArrayList<UUID>();
        for (int i = 0; i < listConnections.size(); ++i) {
            CompoundTag connectionCompound = listConnections.m_128728_(i);
            UUID uuid = connectionCompound.m_128403_("uuid") ? connectionCompound.m_128342_("uuid") : Mth.m_14002_();
            nbtUUIDs.add(uuid);
            if (this.outgoing.containsKey(uuid)) {
                Connection connection = this.outgoing.get(uuid);
                connection.deserialize(connectionCompound.m_128469_("connection"));
                continue;
            }
            ConnectionType type = (ConnectionType)FairyLights.CONNECTION_TYPES.get().getValue(ResourceLocation.m_135820_((String)connectionCompound.m_128461_("type")));
            if (type == null) continue;
            Object connection = type.create(this.world, this, uuid);
            ((Connection)connection).deserialize(connectionCompound.m_128469_("connection"));
            this.outgoing.put(uuid, (Connection)connection);
        }
        Iterator<Map.Entry<UUID, Connection>> connectionsIter = this.outgoing.entrySet().iterator();
        while (connectionsIter.hasNext()) {
            Map.Entry<UUID, Connection> connection = connectionsIter.next();
            if (nbtUUIDs.contains(connection.getKey())) continue;
            connectionsIter.remove();
            connection.getValue().remove();
        }
        this.incoming.clear();
        ListTag incoming = compound.m_128437_("incoming", 10);
        for (int i = 0; i < incoming.size(); ++i) {
            CompoundTag incomingNbt = incoming.m_128728_(i);
            UUID uuid = incomingNbt.m_128342_("uuid");
            FastenerAccessor fastener = FastenerType.deserialize(incomingNbt.m_128469_("fastener"));
            this.incoming.put(uuid, new Incoming(fastener, uuid));
        }
        this.setDirty();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        return capability == CapabilityHandler.FASTENER_CAP ? this.lazyOptional.cast() : LazyOptional.empty();
    }

    static class Incoming {
        final FastenerAccessor fastener;
        final UUID id;

        Incoming(FastenerAccessor fastener, UUID id) {
            this.fastener = fastener;
            this.id = id;
        }

        boolean gone(Level world) {
            return this.fastener.isGone(world);
        }

        Optional<Connection> get(Level world) {
            return this.fastener.get(world, false).map(Optional::of).orElse(Optional.empty()).flatMap(f -> f.get(this.id));
        }
    }
}

